/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.watermark;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.watermark.SubstanceWatermark;

public class SubstanceMosaicWatermark
implements SubstanceWatermark {
    private static Image watermarkImage = null;

    public void drawWatermarkImage(Graphics graphics, Component c, int x, int y, int width, int height) {
        int dx = c.getLocationOnScreen().x;
        int dy = c.getLocationOnScreen().y;
        graphics.drawImage(watermarkImage, x, y, x + width, y + height, x + dx, y + dy, x + dx + width, y + dy + height, null);
    }

    public boolean updateWatermarkImage() {
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        int screenWidth = screenDim.width;
        int screenHeight = screenDim.height;
        watermarkImage = SubstanceImageCreator.getBlankImage(screenWidth, screenHeight);
        Graphics2D graphics = (Graphics2D)watermarkImage.getGraphics().create();
        int sqDim = 7;
        int sqGap = 2;
        int cellDim = sqDim + sqGap;
        int rows = screenHeight / cellDim;
        int columns = screenWidth / cellDim;
        for (int col = 0; col <= columns; ++col) {
            for (int row = 0; row <= rows; ++row) {
                Color stampColor = SubstanceLookAndFeel.getColorScheme().isDark() ? new Color(255, 255, 255, 10 + (int)(15.0 * Math.random())) : new Color(0, 0, 0, 5 + (int)(10.0 * Math.random()));
                graphics.setColor(stampColor);
                graphics.fillRect(col * cellDim, row * cellDim, sqDim, sqDim);
            }
        }
        graphics.dispose();
        return true;
    }

    public String getDisplayName() {
        return SubstanceMosaicWatermark.getName();
    }

    public static String getName() {
        return "Square mosaic";
    }

    public boolean isDependingOnTheme() {
        return true;
    }
}

