/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.watermark;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.security.AccessControlException;
import javax.imageio.ImageIO;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.watermark.SubstanceWatermark;

public class SubstanceImageWatermark
implements SubstanceWatermark {
    private static Image watermarkImage = null;
    private BufferedImage origImage;

    public SubstanceImageWatermark() throws AccessControlException {
        this(System.getProperty("substancelaf.watermark.image"));
    }

    public SubstanceImageWatermark(String imageLocation) {
        if (imageLocation != null) {
            try {
                if (imageLocation.startsWith("http")) {
                    URL url = new URL(imageLocation);
                    this.origImage = ImageIO.read(url);
                } else {
                    this.origImage = ImageIO.read(new File(imageLocation));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void drawWatermarkImage(Graphics graphics, Component c, int x, int y, int width, int height) {
        int dx = c.getLocationOnScreen().x;
        int dy = c.getLocationOnScreen().y;
        graphics.drawImage(watermarkImage, x, y, x + width, y + height, x + dx, y + dy, x + dx + width, y + dy + height, null);
    }

    public boolean updateWatermarkImage() {
        boolean isHeightFits;
        if (this.origImage == null) {
            return false;
        }
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        int screenWidth = screenDim.width;
        int screenHeight = screenDim.height;
        watermarkImage = SubstanceImageCreator.getBlankImage(screenWidth, screenHeight);
        Graphics2D graphics = (Graphics2D)watermarkImage.getGraphics().create();
        AlphaComposite comp = AlphaComposite.getInstance(3, 0.2f);
        graphics.setComposite(comp);
        int origImageWidth = this.origImage.getWidth();
        int origImageHeight = this.origImage.getHeight();
        boolean isWidthFits = origImageWidth <= screenWidth;
        boolean bl = isHeightFits = origImageHeight <= screenHeight;
        if (isWidthFits && isHeightFits) {
            graphics.drawImage((Image)this.origImage, (screenWidth - origImageWidth) / 2, (screenHeight - origImageHeight) / 2, null);
            graphics.dispose();
            return true;
        }
        if (isWidthFits) {
            double scaleFact = (double)screenHeight / (double)origImageHeight;
            int dx = (int)((double)screenWidth - scaleFact * (double)origImageWidth) / 2;
            graphics.drawImage(this.origImage, dx, 0, screenWidth - dx, screenHeight, 0, 0, origImageWidth, origImageHeight, null);
            graphics.dispose();
            return true;
        }
        if (isHeightFits) {
            double scaleFact = (double)screenWidth / (double)origImageWidth;
            int dy = (int)((double)screenHeight - scaleFact * (double)origImageHeight) / 2;
            graphics.drawImage(this.origImage, 0, dy, screenWidth, screenHeight - dy, 0, 0, origImageWidth, origImageHeight, null);
            graphics.dispose();
            return true;
        }
        double scaleFactY = (double)screenHeight / (double)origImageHeight;
        double scaleFactX = (double)screenWidth / (double)origImageWidth;
        double scaleFact = Math.min(scaleFactX, scaleFactY);
        int dx = Math.max(0, (int)((double)screenWidth - scaleFact * (double)origImageWidth) / 2);
        int dy = Math.max(0, (int)((double)screenHeight - scaleFact * (double)origImageHeight) / 2);
        graphics.drawImage(this.origImage, dx, dy, screenWidth - dx, screenHeight - dy, 0, 0, origImageWidth, origImageHeight, null);
        graphics.dispose();
        return true;
    }

    public String getDisplayName() {
        return SubstanceImageWatermark.getName();
    }

    public static String getName() {
        return "Image";
    }

    public boolean isDependingOnTheme() {
        return false;
    }
}

