/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.comp;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;
import org.jvnet.substance.comp.ButtonStripUI;
import org.jvnet.substance.comp.JButtonStrip;

public class BasicButtonStripUI
extends ButtonStripUI {
    protected JButtonStrip buttonStrip;

    public static ComponentUI createUI(JComponent c) {
        return new BasicButtonStripUI();
    }

    public void installUI(JComponent c) {
        this.buttonStrip = (JButtonStrip)c;
        c.setLayout(this.createLayoutManager());
    }

    public void uninstallUI(JComponent c) {
        c.setLayout(null);
        this.buttonStrip = null;
    }

    public void paint(Graphics g, JComponent c) {
        int buttonCount = this.buttonStrip.getButtonCount();
        for (int i = 0; i < buttonCount; ++i) {
            AbstractButton currButton = this.buttonStrip.getButton(i);
            boolean isFirst = this.buttonStrip.isFirst(currButton);
            boolean isLast = this.buttonStrip.isLast(currButton);
            Graphics2D graphics = (Graphics2D)g.create(currButton.getX(), currButton.getY(), currButton.getWidth(), currButton.getHeight());
            if (this.buttonStrip.getOrientation() == JButtonStrip.StripOrientation.HORIZONTAL) {
                this.paintStripButton(graphics, currButton, isFirst, isLast, c.getWidth(), currButton.getX());
            } else {
                this.paintStripButton(graphics, currButton, isFirst, isLast, c.getHeight(), currButton.getY());
            }
            graphics.dispose();
        }
    }

    protected void paintStripButton(Graphics g, AbstractButton button, boolean isFirst, boolean isLast, int totalStripDimension, int relativeOffset) {
        this.paintStripButtonBackground(g, button, isFirst, isLast, totalStripDimension, relativeOffset);
        BasicButtonUI buttonUI = (BasicButtonUI)button.getUI();
        buttonUI.paint(g, button);
        this.paintStripButtonBorder(g, button, isFirst, isLast);
    }

    protected void paintStripButtonBackground(Graphics g, AbstractButton button, boolean isFirst, boolean isLast, int totalStripDimension, int relativeOffset) {
        if (button.isOpaque()) {
            g.setColor(button.getBackground());
            g.fillRect(0, 0, button.getWidth(), button.getHeight());
        }
    }

    protected void paintStripButtonBorder(Graphics g, AbstractButton button, boolean isFirst, boolean isLast) {
        Border border = button.getBorder();
        if (border != null) {
            border.paintBorder(button, g, 0, 0, button.getWidth(), button.getHeight());
        }
    }

    protected LayoutManager createLayoutManager() {
        return new ButtonStripLayout();
    }

    private class ButtonStripLayout
    implements LayoutManager {
        private ButtonStripLayout() {
        }

        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            int width = 0;
            int height = 0;
            if (BasicButtonStripUI.this.buttonStrip.getOrientation() == JButtonStrip.StripOrientation.HORIZONTAL) {
                for (int i = 0; i < BasicButtonStripUI.this.buttonStrip.getButtonCount(); ++i) {
                    width += BasicButtonStripUI.this.buttonStrip.getButton((int)i).getPreferredSize().width;
                    height = Math.max(height, BasicButtonStripUI.this.buttonStrip.getButton((int)i).getPreferredSize().height);
                }
            } else {
                for (int i = 0; i < BasicButtonStripUI.this.buttonStrip.getButtonCount(); ++i) {
                    height += BasicButtonStripUI.this.buttonStrip.getButton((int)i).getPreferredSize().height;
                    width = Math.max(width, BasicButtonStripUI.this.buttonStrip.getButton((int)i).getPreferredSize().width);
                }
            }
            return new Dimension(width, height);
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        public void layoutContainer(Container c) {
            if (BasicButtonStripUI.this.buttonStrip.getOrientation() == JButtonStrip.StripOrientation.HORIZONTAL) {
                int x = 0;
                int height = c.getHeight();
                for (int i = 0; i < BasicButtonStripUI.this.buttonStrip.getButtonCount(); ++i) {
                    AbstractButton currButton = BasicButtonStripUI.this.buttonStrip.getButton(i);
                    currButton.setBounds(x, 0, currButton.getPreferredSize().width, height);
                    x += currButton.getPreferredSize().width;
                }
            } else {
                int y = 0;
                int width = c.getWidth();
                for (int i = 0; i < BasicButtonStripUI.this.buttonStrip.getButtonCount(); ++i) {
                    AbstractButton currButton = BasicButtonStripUI.this.buttonStrip.getButton(i);
                    currButton.setBounds(0, y, width, currButton.getPreferredSize().height);
                    y += currButton.getPreferredSize().height;
                }
            }
        }
    }
}

