/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalRadioButtonUI;
import org.jvnet.substance.ComponentState;
import org.jvnet.substance.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.SubstanceImageCreator;

public class SubstanceRadioButtonUI
extends MetalRadioButtonUI {
    private static final int DIMENSION = 12;
    private SubstanceFillBackgroundDelegate bgDelegate = new SubstanceFillBackgroundDelegate();
    protected JToggleButton button;
    private static Map<ComponentState, Icon> icons;

    static synchronized void reset() {
        icons = new HashMap<ComponentState, Icon>();
        for (ComponentState state : ComponentState.values()) {
            icons.put(state, new ImageIcon(SubstanceImageCreator.getRadioButton(12, state)));
        }
    }

    public static ComponentUI createUI(JComponent b) {
        return new SubstanceRadioButtonUI((JToggleButton)b);
    }

    public SubstanceRadioButtonUI(JToggleButton button) {
        this.button = button;
        button.setRolloverEnabled(true);
    }

    public Icon getDefaultIcon() {
        ButtonModel model = this.button.getModel();
        return icons.get((Object)ComponentState.getState(model, this.button));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update(Graphics g, JComponent c) {
        JComponent jComponent = c;
        synchronized (jComponent) {
            this.bgDelegate.update(g, c);
            boolean isOpaque = c.isOpaque();
            c.setOpaque(false);
            this.bgDelegate.update(g, c);
            super.paint(g, c);
            c.setOpaque(isOpaque);
        }
    }

    protected void paintFocus(Graphics g, Rectangle t, Dimension d) {
    }

    static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceRadioButtonUI: \n");
        sb.append("\t" + icons.size() + " icons");
        return sb.toString();
    }

    static {
        SubstanceRadioButtonUI.reset();
    }
}

