/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuBarUI;
import org.jvnet.substance.MemoryAnalyzer;
import org.jvnet.substance.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstanceTitlePane;

public class SubstanceMenuBarUI
extends BasicMenuBarUI {
    private static SubstanceFillBackgroundDelegate backgroundDelegate = new SubstanceFillBackgroundDelegate();
    private static boolean inEvent = false;
    private static WeakHashMap<JMenuBar, SearchPanel> panels = new WeakHashMap();

    private static int getMenuItemCount(JMenuItem menuItem) {
        int result = 1;
        if (menuItem instanceof JMenu) {
            JMenu menu = (JMenu)menuItem;
            for (Component child : menu.getMenuComponents()) {
                if (!(child instanceof JMenuItem)) continue;
                result += SubstanceMenuBarUI.getMenuItemCount((JMenuItem)child);
            }
        }
        return result;
    }

    private static int getMenuItemCount(JMenuBar menuBar) {
        int result = 0;
        for (int i = 0; i < menuBar.getMenuCount(); ++i) {
            JMenu menu = menuBar.getMenu(i);
            if (menu == null) continue;
            result += SubstanceMenuBarUI.getMenuItemCount(menu);
        }
        return result;
    }

    public static ComponentUI createUI(JComponent c) {
        if (MemoryAnalyzer.isRunning()) {
            MemoryAnalyzer.enqueueUsage("SubstanceMenuBarUI to be created");
        }
        SubstanceMenuBarUI result = new SubstanceMenuBarUI();
        final JMenuBar jmb = (JMenuBar)c;
        boolean toAddListener = false;
        if (!(jmb instanceof SubstanceTitlePane.SubstanceMenuBar) && !panels.containsKey(jmb)) {
            SubstanceMenuBarUI substanceMenuBarUI = result;
            substanceMenuBarUI.getClass();
            SearchPanel searchPanel = substanceMenuBarUI.new SearchPanel(jmb);
            jmb.add((Component)searchPanel, jmb.getComponentCount() - 1);
            panels.put(jmb, searchPanel);
            toAddListener = true;
        }
        if (toAddListener) {
            jmb.addContainerListener(new ContainerAdapter(){

                public void componentAdded(ContainerEvent e) {
                    if (!(e.getChild() instanceof JMenu)) {
                        return;
                    }
                    if (!inEvent) {
                        boolean isTracingOn = MemoryAnalyzer.isRunning();
                        inEvent = true;
                        Component removed = null;
                        for (int i = 0; i < jmb.getComponentCount(); ++i) {
                            if (!(jmb.getComponent(i) instanceof SearchPanel)) continue;
                            if (isTracingOn) {
                                MemoryAnalyzer.enqueueUsage("At " + i + " have search panel");
                            }
                            removed = jmb.getComponent(i);
                            break;
                        }
                        if (removed != null) {
                            jmb.remove(removed);
                            if (isTracingOn) {
                                MemoryAnalyzer.enqueueUsage("Adding at " + jmb.getComponentCount() + " out of " + jmb.getComponentCount());
                            }
                            jmb.add(removed, jmb.getComponentCount());
                            if (SubstanceMenuBarUI.getMenuItemCount(jmb) > 40) {
                                removed.setVisible(true);
                            } else {
                                removed.setVisible(false);
                            }
                        }
                        inEvent = false;
                    }
                }
            });
        }
        return new SubstanceMenuBarUI();
    }

    public void update(Graphics g, JComponent c) {
        boolean isOpaque = c.isOpaque();
        if (isOpaque) {
            backgroundDelegate.update(g, c);
        } else {
            super.update(g, c);
        }
    }

    public static void reset() {
        for (SearchPanel searchPanel : panels.values()) {
            for (Map.Entry entry : searchPanel.resultButtons.entrySet()) {
                int index = (Integer)entry.getKey();
                JButton button = (JButton)entry.getValue();
                button.setIcon(SubstanceImageCreator.getHexaMarker(index, SubstanceLookAndFeel.getColorScheme()));
            }
            searchPanel.searchButton.setIcon(SubstanceImageCreator.getSearchIcon(14, SubstanceLookAndFeel.getColorScheme()));
        }
    }

    private class SearchResultsLayout
    implements LayoutManager {
        private SearchPanel searchPanel;

        public SearchResultsLayout(SearchPanel searchPanel) {
            this.searchPanel = searchPanel;
        }

        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            if (this.searchPanel.searchButton.isSelected()) {
                return c.getSize();
            }
            return new Dimension(16, 16);
        }

        public Dimension minimumLayoutSize(Container c) {
            return new Dimension(16, 16);
        }

        public void layoutContainer(Container c) {
            int height = c.getHeight();
            if (!this.searchPanel.searchButton.isVisible()) {
                return;
            }
            int x = 0;
            int sbWidth = ((SearchPanel)this.searchPanel).searchButton.getPreferredSize().width;
            int sbHeight = ((SearchPanel)this.searchPanel).searchButton.getPreferredSize().height;
            this.searchPanel.searchButton.setBounds(x, (height - sbHeight) / 2, sbWidth, sbHeight);
            x += sbWidth + 4;
            if (this.searchPanel.isVisible()) {
                int tbWidth = ((SearchPanel)this.searchPanel).searchStringField.getPreferredSize().width;
                int tbHeight = ((SearchPanel)this.searchPanel).searchStringField.getPreferredSize().height;
                this.searchPanel.searchStringField.setBounds(x, (height - tbHeight) / 2, tbWidth, tbHeight);
                x += tbWidth + 2;
                int buttonCount = this.searchPanel.resultButtons.size();
                for (int i = 1; i <= buttonCount; ++i) {
                    JButton button = (JButton)this.searchPanel.resultButtons.get(i);
                    int bw = button.getPreferredSize().width;
                    int bh = button.getPreferredSize().height;
                    button.setBounds(x, (height - bh) / 2, bw, bh);
                    x += bw + 1;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SearchResult {
        private MenuElement[] menuElements;

        public SearchResult(JMenuBar menuBar, LinkedList<JMenu> menuPath, JMenuItem menuLeaf) {
            int count = 1;
            if (menuPath != null) {
                count += 2 * menuPath.size();
            }
            if (menuLeaf != null) {
                ++count;
            }
            this.menuElements = new MenuElement[count];
            count = 0;
            this.menuElements[count++] = menuBar;
            if (menuPath != null) {
                for (JMenu menu : menuPath) {
                    this.menuElements[count++] = menu;
                    this.menuElements[count++] = menu.getPopupMenu();
                }
            }
            if (menuLeaf != null) {
                this.menuElements[count] = menuLeaf;
            }
        }

        public MenuElement[] getMenuElements() {
            return this.menuElements;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.menuElements != null) {
                String sep = "";
                for (MenuElement menu : this.menuElements) {
                    if (!(menu instanceof JMenuItem)) continue;
                    sb.append(sep);
                    sep = " -> ";
                    sb.append(((JMenuItem)menu).getText());
                }
            }
            return sb.toString();
        }

        public boolean isEnabled() {
            for (MenuElement element : this.menuElements) {
                JMenuItem menuItem;
                if (!(element instanceof JMenuItem) || (menuItem = (JMenuItem)element).isEnabled()) continue;
                return false;
            }
            return true;
        }
    }

    private static class SearchResultListener
    implements ActionListener {
        private SearchResult searchResult;

        public SearchResultListener(SearchResult searchResult) {
            this.searchResult = searchResult;
        }

        public void actionPerformed(ActionEvent e) {
            MenuElement[] menuElements = this.searchResult.menuElements;
            MenuSelectionManager.defaultManager().setSelectedPath(menuElements);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SearchPanel
    extends JPanel {
        private JToggleButton searchButton;
        private JTextField searchStringField;
        private JMenuBar menuBar;
        private Map<Integer, JButton> resultButtons;

        public SearchPanel(final JMenuBar menuBar) {
            this.menuBar = menuBar;
            this.setLayout(new SearchResultsLayout(this));
            this.searchButton = new JToggleButton(SubstanceImageCreator.getSearchIcon(14, SubstanceLookAndFeel.getColorScheme()));
            this.searchButton.setPreferredSize(new Dimension(16, 16));
            this.searchButton.setToolTipText("Select to view menu search panel");
            this.add(this.searchButton);
            this.searchButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            boolean toShow = SearchPanel.this.searchButton.isSelected();
                            SearchPanel.this.searchStringField.setVisible(toShow);
                            SearchPanel.this.searchStringField.requestFocus();
                            for (JButton resultButton : SearchPanel.this.resultButtons.values()) {
                                resultButton.setVisible(toShow);
                            }
                            SearchPanel.this.repaint();
                            SearchPanel.this.revalidate();
                        }
                    });
                }
            });
            this.searchButton.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    if ((e.getModifiers() & 2) != 0) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                SearchPanel.this.removeAll();
                                SearchPanel.this.repaint();
                                menuBar.revalidate();
                            }
                        });
                    }
                }
            });
            this.searchStringField = new JTextField();
            this.searchStringField.setColumns(10);
            this.add(this.searchStringField);
            this.searchStringField.setVisible(false);
            this.searchStringField.setToolTipText("Enter search string and press 'Enter' button to search");
            this.resultButtons = new HashMap<Integer, JButton>();
            this.searchStringField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String searchString = SearchPanel.this.searchStringField.getText().toLowerCase();
                    if (searchString.trim().length() == 0) {
                        return;
                    }
                    for (JButton resultButton : SearchPanel.this.resultButtons.values()) {
                        SearchPanel.this.remove(resultButton);
                    }
                    SearchPanel.this.resultButtons.clear();
                    LinkedList searchResults = SearchPanel.this.findOccurences(searchString);
                    int count = 0;
                    for (SearchResult searchResult : searchResults) {
                        if (count == 16) break;
                        JButton resultButton = new JButton(SubstanceImageCreator.getHexaMarker(count + 1, SubstanceLookAndFeel.getColorScheme()));
                        resultButton.addActionListener(new SearchResultListener(searchResult));
                        resultButton.setEnabled(searchResult.isEnabled());
                        SearchPanel.this.add(resultButton);
                        SearchPanel.this.resultButtons.put(count + 1, resultButton);
                        resultButton.setToolTipText("<html><body><b>" + searchResult.toString() + "</b><br>Click to locate menu</html>");
                        ++count;
                    }
                    SearchPanel.this.repaint();
                    menuBar.revalidate();
                }
            });
        }

        private LinkedList<SearchResult> findOccurences(String searchPattern) {
            LinkedList<SearchResult> result = new LinkedList<SearchResult>();
            LinkedList<JMenu> currentPath = new LinkedList<JMenu>();
            for (Component component : this.menuBar.getComponents()) {
                if (!(component instanceof JMenu)) continue;
                JMenu menu = (JMenu)component;
                this.checkMenu(currentPath, menu, searchPattern, result);
            }
            return result;
        }

        private void checkMenu(LinkedList<JMenu> currentPath, JMenuItem menuItem, String searchPattern, LinkedList<SearchResult> matchingResults) {
            String menuItemText = menuItem.getText();
            if (menuItemText.toLowerCase().contains(searchPattern)) {
                matchingResults.addLast(new SearchResult(this.menuBar, currentPath, menuItem));
            }
            if (menuItem instanceof JMenu) {
                JMenu menu = (JMenu)menuItem;
                currentPath.addLast(menu);
                for (Component menuComponent : menu.getMenuComponents()) {
                    if (!(menuComponent instanceof JMenuItem)) continue;
                    JMenuItem childItem = (JMenuItem)menuComponent;
                    this.checkMenu(currentPath, childItem, searchPattern, matchingResults);
                }
                currentPath.removeLast();
            }
        }

        @Override
        public void setVisible(boolean aFlag) {
            super.setVisible(aFlag);
            if (aFlag) {
                this.searchStringField.requestFocus();
            }
        }
    }
}

