/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.color.ColorSchemeEnum;

public class SubstanceGradientBackgroundDelegate {
    private static Map<String, BufferedImage> backgrounds = new HashMap<String, BufferedImage>();

    static synchronized void reset() {
        backgrounds.clear();
    }

    private synchronized BufferedImage getBackground(int width, int height, ColorSchemeEnum colorSchemeEnum, boolean hasDarkBorder) {
        String key = width + "*" + height + ":" + colorSchemeEnum.toString() + ":" + hasDarkBorder;
        if (!backgrounds.containsKey(key)) {
            BufferedImage newOne = SubstanceImageCreator.getRectangularBackground(width, height, colorSchemeEnum, hasDarkBorder);
            backgrounds.put(key, newOne);
        }
        return backgrounds.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Graphics g, Component c, int width, int height, ColorSchemeEnum colorSchemeEnum, boolean hasDarkBorder) {
        if (!c.isShowing()) {
            return;
        }
        Component component = c;
        synchronized (component) {
            g.drawImage(this.getBackground(width, height, colorSchemeEnum, hasDarkBorder), 0, 0, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Graphics g, Component c, Rectangle rect, ColorSchemeEnum colorSchemeEnum, boolean hasDarkBorder) {
        Component component = c;
        synchronized (component) {
            g.drawImage(this.getBackground(rect.width, rect.height, colorSchemeEnum, hasDarkBorder), rect.x, rect.y, null);
        }
    }

    static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceGradientBackgroundDelegate: \n");
        sb.append("\t" + backgrounds.size() + " backgrounds");
        return sb.toString();
    }
}

