/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.event.MouseEvent;
import java.util.WeakHashMap;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.plaf.basic.BasicButtonListener;

public class RolloverButtonListener
extends BasicButtonListener {
    private boolean isMouseInside;
    private AbstractButton button;
    private static WeakHashMap<AbstractButton, RolloverButtonListener> listeners = new WeakHashMap();

    public static RolloverButtonListener getListener(AbstractButton b) {
        if (listeners.containsKey(b) && listeners.get(b) != null) {
            return listeners.get(b);
        }
        RolloverButtonListener rlb = new RolloverButtonListener(b);
        b.setRolloverEnabled(true);
        listeners.put(b, rlb);
        return rlb;
    }

    protected RolloverButtonListener(AbstractButton b) {
        super(b);
        this.button = b;
        this.isMouseInside = false;
    }

    public void mouseEntered(MouseEvent e) {
        super.mouseEntered(e);
        this.isMouseInside = true;
        this.button.getModel().setRollover(true);
    }

    public void mouseExited(MouseEvent e) {
        super.mouseExited(e);
        this.isMouseInside = false;
        this.button.getModel().setRollover(false);
    }

    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        this.button.getModel().setRollover(this.isMouseInside);
    }

    public void clearState() {
        this.isMouseInside = false;
        ButtonModel model = this.button.getModel();
        model.setArmed(false);
        model.setPressed(false);
        model.setRollover(false);
        model.setSelected(false);
    }
}

