/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.watermark;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.watermark.SubstanceWatermark;

public class SubstanceStripeWatermark
implements SubstanceWatermark {
    private static Image watermarkImage = null;

    public void drawWatermarkImage(Graphics graphics, Component c, int x, int y, int width, int height) {
        int dx = c.getLocationOnScreen().x;
        int dy = c.getLocationOnScreen().y;
        graphics.drawImage(watermarkImage, x, y, x + width, y + height, x + dx, y + dy, x + dx + width, y + dy + height, null);
    }

    public boolean updateWatermarkImage() {
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        int screenWidth = screenDim.width;
        int screenHeight = screenDim.height;
        watermarkImage = SubstanceImageCreator.getBlankImage(screenWidth, screenHeight);
        Graphics2D graphics = (Graphics2D)watermarkImage.getGraphics().create();
        Color stampColor = SubstanceLookAndFeel.getColorScheme().isDark() ? new Color(255, 255, 255, 25) : new Color(0, 0, 0, 15);
        graphics.setColor(stampColor);
        for (int row = 0; row < screenHeight; row += 2) {
            graphics.drawLine(0, row, screenWidth, row);
        }
        graphics.dispose();
        return true;
    }

    public String getDisplayName() {
        return SubstanceStripeWatermark.getName();
    }

    public static String getName() {
        return "Stripes";
    }

    public boolean isDependingOnTheme() {
        return true;
    }
}

