/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.comp;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.plaf.ComponentUI;
import org.jvnet.substance.comp.JButtonStrip;
import org.jvnet.substance.comp.JRibbon;
import org.jvnet.substance.comp.JRibbonBand;
import org.jvnet.substance.comp.RibbonUI;

public class BasicRibbonUI
extends RibbonUI {
    public static final int TASKBAR_HEIGHT = 22;
    public static final int BAND_MIN_WIDTH = 30;
    protected JRibbon ribbon;

    public static ComponentUI createUI(JComponent c) {
        return new BasicRibbonUI();
    }

    public void installUI(JComponent c) {
        this.ribbon = (JRibbon)c;
        c.setLayout(this.createLayoutManager());
    }

    public void uninstallUI(JComponent c) {
        c.setLayout(null);
        this.ribbon = null;
    }

    public Rectangle getTabBounds(JButtonStrip pane, int index) {
        return null;
    }

    public int tabForCoordinate(JButtonStrip pane, int x, int y) {
        return 0;
    }

    protected LayoutManager createLayoutManager() {
        return new RibbonLayout();
    }

    private class RibbonLayout
    implements LayoutManager {
        public static final int TOTAL_HEIGHT = 108;

        private RibbonLayout() {
        }

        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            return new Dimension(c.getWidth(), 108);
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        public void layoutContainer(Container c) {
            int pw;
            int x = 2;
            for (Component regComp : BasicRibbonUI.this.ribbon.getRegularComponents()) {
                pw = regComp.getPreferredSize().width;
                regComp.setBounds(x, 0, pw, 22);
                x += pw + 2;
            }
            for (JToggleButton taskToggleButton : BasicRibbonUI.this.ribbon.getTaskToggleButtons()) {
                pw = taskToggleButton.getPreferredSize().width;
                taskToggleButton.setBounds(x, 0, pw, 22);
                x += pw + 10;
            }
            int totalPreferredWidth = 0;
            for (JRibbonBand panel : BasicRibbonUI.this.ribbon.getBands()) {
                int pw2 = Math.max(30, panel.getPreferredSize().width);
                totalPreferredWidth += pw2 + 2;
            }
            double coef = (double)c.getWidth() / (double)totalPreferredWidth;
            if (coef >= 1.2) {
                coef = 1.2;
            }
            x = 0;
            for (JRibbonBand panel : BasicRibbonUI.this.ribbon.getBands()) {
                int pw3 = Math.max(30, panel.getPreferredSize().width);
                int fw = (int)(coef * (double)pw3);
                panel.setBounds(x, 22, fw, 86);
                panel.getControlPanel().setBounds(1, 18, fw - 2, 67);
                if (panel.expandButton != null) {
                    int ebpw = panel.expandButton.getPreferredSize().width;
                    int ebph = panel.expandButton.getPreferredSize().height;
                    panel.expandButton.setBounds(fw - 4 - ebpw, (18 - ebph) / 2, ebpw, ebph);
                }
                panel.doLayout();
                x += fw + 2;
            }
        }
    }
}

