/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.color;

import org.jvnet.substance.color.AquaColorScheme;
import org.jvnet.substance.color.BarbyPinkColorScheme;
import org.jvnet.substance.color.BottleGreenColorScheme;
import org.jvnet.substance.color.BrownColorScheme;
import org.jvnet.substance.color.CharcoalColorScheme;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.color.DarkGrayColorScheme;
import org.jvnet.substance.color.DarkMetallicColorScheme;
import org.jvnet.substance.color.DarkVioletColorScheme;
import org.jvnet.substance.color.EbonyColorScheme;
import org.jvnet.substance.color.LightAquaColorScheme;
import org.jvnet.substance.color.LightGrayColorScheme;
import org.jvnet.substance.color.LimeGreenColorScheme;
import org.jvnet.substance.color.MetallicColorScheme;
import org.jvnet.substance.color.OliveColorScheme;
import org.jvnet.substance.color.OrangeColorScheme;
import org.jvnet.substance.color.PurpleColorScheme;
import org.jvnet.substance.color.RaspberryColorScheme;
import org.jvnet.substance.color.SepiaColorScheme;
import org.jvnet.substance.color.SteelBlueColorScheme;
import org.jvnet.substance.color.SunGlareColorScheme;
import org.jvnet.substance.color.SunsetColorScheme;
import org.jvnet.substance.color.TerracottaColorScheme;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ColorSchemeEnum {
    LIGHT_GRAY(new LightGrayColorScheme(), false, "Light gray"),
    DARK_GRAY(new DarkGrayColorScheme(), true, "Dark gray"),
    METALLIC(new MetallicColorScheme(), false, "Metallic"),
    DARK_METALLIC(new DarkMetallicColorScheme(), true, "Dark metallic"),
    AQUA(new AquaColorScheme(), false, "Aqua"),
    LIGHT_AQUA(new LightAquaColorScheme(), false, "Light aqua"),
    ORANGE(new OrangeColorScheme(), false, "Orange"),
    PURPLE(new PurpleColorScheme(), false, "Purple"),
    LIME_GREEN(new LimeGreenColorScheme(), false, "Lime green"),
    SUN_GLARE(new SunGlareColorScheme(), false, "Sun glare"),
    SUNSET(new SunsetColorScheme(), false, "Sunset"),
    OLIVE(new OliveColorScheme(), false, "Olive"),
    TERRACOTTA(new TerracottaColorScheme(), false, "Terracotta"),
    SEPIA(new SepiaColorScheme(), false, "Sepia"),
    STEEL_BLUE(new SteelBlueColorScheme(), false, "Steel blue"),
    EBONY(new EbonyColorScheme(), true, "Ebony"),
    CHARCOAL(new CharcoalColorScheme(), true, "Charcoal"),
    DARK_VIOLET(new DarkVioletColorScheme(), true, "Dark violet"),
    BROWN(new BrownColorScheme(), false, "Brown"),
    BOTTLE_GREEN(new BottleGreenColorScheme(), false, "Bottle green"),
    RASPBERRY(new RaspberryColorScheme(), false, "Raspberry"),
    BARBY_PINK(new BarbyPinkColorScheme(), false, "Barby pink"),
    USER_DEFINED(new AquaColorScheme(), false, "User defined");

    private ColorScheme colorScheme;
    private boolean isDark;
    private String displayName;

    private ColorSchemeEnum(ColorScheme colorScheme, boolean isDark, String displayName) {
        this.colorScheme = colorScheme;
        this.isDark = isDark;
        this.displayName = displayName;
    }

    public ColorScheme getColorScheme() {
        return this.colorScheme;
    }

    public boolean isDark() {
        return this.isDark;
    }

    public ColorSchemeEnum getMetallic() {
        if (this.isDark()) {
            return DARK_METALLIC;
        }
        return METALLIC;
    }

    public ColorSchemeEnum getGray() {
        if (this.isDark()) {
            return DARK_GRAY;
        }
        return LIGHT_GRAY;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static void setUserDefined(ColorScheme scheme, boolean isDark, String displayName) {
        ColorSchemeEnum.USER_DEFINED.colorScheme = scheme;
        ColorSchemeEnum.USER_DEFINED.isDark = isDark;
        ColorSchemeEnum.USER_DEFINED.displayName = displayName;
    }
}

