/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Color;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPasswordFieldUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PasswordView;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.jvnet.substance.FocusBorderListener;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.color.ColorSchemeEnum;

public class SubstancePasswordFieldUI
extends BasicPasswordFieldUI {
    public static final int PASSWORD_DOT_DIAMETER = 7;
    public static final int PASSWORD_DOT_GAP = 2;
    public static final int PASSWORD_DOT_WIDTH = 9;

    public static ComponentUI createUI(JComponent c) {
        c.addFocusListener(new FocusBorderListener(c));
        return new SubstancePasswordFieldUI();
    }

    public View create(Element elem) {
        return new SubstancePasswordView(elem);
    }

    private static class SubstancePasswordView
    extends PasswordView {
        public SubstancePasswordView(Element element) {
            super(element);
        }

        protected int drawEchoCharacter(Graphics g, int x, int y, char c) {
            Container container = this.getContainer();
            if (!(container instanceof JPasswordField)) {
                return super.drawEchoCharacter(g, x, y, c);
            }
            Graphics2D graphics = (Graphics2D)g;
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            JPasswordField field = (JPasswordField)container;
            ColorSchemeEnum colorSchemeEnum = field.isEnabled() ? SubstanceLookAndFeel.getColorScheme() : SubstanceLookAndFeel.getColorScheme().getMetallic();
            Color topColor = colorSchemeEnum.isDark() ? colorSchemeEnum.getColorScheme().getExtraLightColor().brighter() : colorSchemeEnum.getColorScheme().getUltraDarkColor();
            Color bottomColor = colorSchemeEnum.isDark() ? colorSchemeEnum.getColorScheme().getUltraLightColor().brighter() : colorSchemeEnum.getColorScheme().getDarkColor();
            graphics.setPaint(new GradientPaint(x, y - 7, topColor, x, y, bottomColor));
            graphics.fillOval(x, y - 7, 7, 7);
            return x + 9;
        }

        protected int drawSelectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
            return super.drawSelectedText(g, x, y, p0, p1);
        }

        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
            Container c = this.getContainer();
            if (c instanceof JPasswordField) {
                JPasswordField f = (JPasswordField)c;
                if (!f.echoCharIsSet()) {
                    return super.modelToView(pos, a, b);
                }
                Rectangle alloc = this.adjustAllocation(a).getBounds();
                int dx = (pos - this.getStartOffset()) * 9;
                alloc.x += dx;
                alloc.width = 1;
                return alloc;
            }
            return null;
        }

        public int viewToModel(float fx, float fy, Shape a, Position.Bias[] bias) {
            bias[0] = Position.Bias.Forward;
            int n = 0;
            Container c = this.getContainer();
            if (c instanceof JPasswordField) {
                JPasswordField f = (JPasswordField)c;
                if (!f.echoCharIsSet()) {
                    return super.viewToModel(fx, fy, a, bias);
                }
                Rectangle alloc = (a = this.adjustAllocation(a)) instanceof Rectangle ? (Rectangle)a : a.getBounds();
                n = ((int)fx - alloc.x) / 9;
                if (n < 0) {
                    n = 0;
                } else if (n > this.getStartOffset() + this.getDocument().getLength()) {
                    n = this.getDocument().getLength() - this.getStartOffset();
                }
            }
            return this.getStartOffset() + n;
        }

        public float getPreferredSpan(int axis) {
            switch (axis) {
                case 0: {
                    JPasswordField f;
                    Container c = this.getContainer();
                    if (!(c instanceof JPasswordField) || !(f = (JPasswordField)c).echoCharIsSet()) break;
                    return 9 * this.getDocument().getLength();
                }
            }
            return super.getPreferredSpan(axis);
        }
    }
}

