/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.jvnet.substance.PulseTracker;
import org.jvnet.substance.SubstanceBackgroundDelegate;
import org.jvnet.substance.SubstanceCheckBoxUI;
import org.jvnet.substance.SubstanceComboBoxUI;
import org.jvnet.substance.SubstanceGradientBackgroundDelegate;
import org.jvnet.substance.SubstanceProgressBarUI;
import org.jvnet.substance.SubstanceRadioButtonUI;
import org.jvnet.substance.SubstanceRootPaneUI;
import org.jvnet.substance.SubstanceScrollBarUI;
import org.jvnet.substance.SubstanceTabbedPaneUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryAnalyzer
extends Thread {
    private long delay;
    private String filename;
    private static MemoryAnalyzer instance;
    private static boolean isStopRequest;
    private static ArrayList<String> usages;
    private static SimpleDateFormat sdf;

    private MemoryAnalyzer(long delay, String filename) {
        this.delay = delay;
        this.filename = filename;
    }

    public static synchronized void commence(long delay, String filename) {
        if (instance == null) {
            instance = new MemoryAnalyzer(delay, filename);
            usages = new ArrayList();
            sdf = new SimpleDateFormat("HH:mm:ss.SSS");
            instance.start();
        }
    }

    public static synchronized void requestStop() {
        isStopRequest = true;
    }

    private static synchronized boolean hasStopRequest() {
        return isStopRequest;
    }

    public static boolean isRunning() {
        return instance != null;
    }

    public static synchronized void enqueueUsage(String usage) {
        if (instance != null) {
            usages.add(sdf.format(new Date()) + ": " + usage);
        }
    }

    public static synchronized ArrayList<String> getUsages() {
        ArrayList<String> copy = new ArrayList<String>();
        for (String usage : usages) {
            copy.add(usage);
        }
        usages.clear();
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(new File(this.filename), true));
            bw.write(sdf.format(new Date()) + "\n");
            UIDefaults uidefs = UIManager.getLookAndFeelDefaults();
            Set keySet = uidefs.keySet();
            LinkedList<String> keyList = new LinkedList<String>();
            for (Object k : keySet) {
                keyList.add((String)k);
            }
            Collections.sort(keyList);
            for (String string : keyList) {
                Object v = uidefs.get(string);
                if (v instanceof Integer) {
                    int intVal = uidefs.getInt(string);
                    bw.write(string + " (int) : " + intVal);
                } else if (v instanceof Boolean) {
                    boolean boolVal = uidefs.getBoolean(string);
                    bw.write(string + " (bool) : " + boolVal);
                } else if (v instanceof String) {
                    String strVal = uidefs.getString(string);
                    bw.write(string + " (string) : " + strVal);
                } else if (v instanceof Dimension) {
                    Dimension dimVal = uidefs.getDimension(string);
                    bw.write(string + " (Dimension) : " + dimVal.width + "*" + dimVal.height);
                } else if (v instanceof Insets) {
                    Insets insetsVal = uidefs.getInsets(string);
                    bw.write(string + " (Insets) : " + insetsVal.top + "*" + insetsVal.left + "*" + insetsVal.bottom + "*" + insetsVal.right);
                } else if (v instanceof Color) {
                    Color colorVal = uidefs.getColor(string);
                    bw.write(string + " (int) : " + colorVal.getRed() + "," + colorVal.getGreen() + "," + colorVal.getBlue());
                } else if (v instanceof Font) {
                    Font fontVal = uidefs.getFont(string);
                    bw.write(string + " (Font) : " + fontVal.getFontName() + "*" + fontVal.getSize());
                } else {
                    bw.write(string + " (Object) : " + uidefs.get(string));
                }
                bw.write("\n");
            }
        }
        catch (IOException ioe) {
            MemoryAnalyzer.requestStop();
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (Exception exc) {}
            }
        }
        while (!MemoryAnalyzer.hasStopRequest()) {
            bw = null;
            try {
                bw = new BufferedWriter(new FileWriter(new File(this.filename), true));
                bw.write(sdf.format(new Date()) + "\n");
                bw.write(PulseTracker.getMemoryUsage() + "\n");
                bw.write(SubstanceBackgroundDelegate.getMemoryUsage() + "\n");
                bw.write(SubstanceCheckBoxUI.getMemoryUsage() + "\n");
                bw.write(SubstanceComboBoxUI.getMemoryUsage() + "\n");
                bw.write(SubstanceGradientBackgroundDelegate.getMemoryUsage() + "\n");
                bw.write(SubstanceProgressBarUI.getMemoryUsage() + "\n");
                bw.write(SubstanceRadioButtonUI.getMemoryUsage() + "\n");
                bw.write(SubstanceRootPaneUI.getMemoryUsage() + "\n");
                bw.write(SubstanceScrollBarUI.getMemoryUsage() + "\n");
                bw.write(SubstanceTabbedPaneUI.getMemoryUsage() + "\n");
                ArrayList<String> usages = MemoryAnalyzer.getUsages();
                for (String usage : usages) {
                    bw.write(usage + "\n");
                }
                bw.write("\n");
            }
            catch (IOException ioe) {
                MemoryAnalyzer.requestStop();
            }
            finally {
                if (bw != null) {
                    try {
                        bw.close();
                    }
                    catch (Exception exc) {}
                }
            }
            try {
                MemoryAnalyzer.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    static {
        isStopRequest = false;
    }
}

