/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaUtilities;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.plaf.UIResource;

public class ButtonStateIcon
implements Icon,
UIResource {
    private static final int E = 0;
    private static final int EP = 1;
    private static final int ES = 2;
    private static final int EPS = 3;
    private static final int D = 4;
    private static final int DS = 5;
    private static final int I = 6;
    private static final int IS = 7;
    private static final int DI = 8;
    private static final int DIS = 9;
    private Icon[] icons = new Icon[10];
    private int width;
    private int height;

    public ButtonStateIcon(Icon e, Icon ep, Icon es, Icon eps, Icon d, Icon ds) {
        this.icons[0] = e;
        this.icons[1] = ep;
        this.icons[2] = es;
        this.icons[3] = eps;
        this.icons[4] = d;
        this.icons[5] = ds;
        for (int i = 0; i < this.icons.length; ++i) {
            if (this.icons[i] == null) continue;
            this.width = this.icons[i].getIconWidth();
            this.height = this.icons[i].getIconHeight();
            break;
        }
        this.generateMissingIcons();
    }

    public ButtonStateIcon(Image[] images) {
        int n = Math.min(images.length, this.icons.length);
        for (int i = 0; i < n; ++i) {
            if (images[i] == null) continue;
            this.icons[i] = new ImageIcon(images[i]);
            this.width = this.icons[i].getIconWidth();
            this.height = this.icons[i].getIconHeight();
        }
        this.generateMissingIcons();
    }

    public ButtonStateIcon(Icon[] icons) {
        System.arraycopy(icons, 0, this.icons, 0, Math.min(icons.length, this.icons.length));
        for (int i = 0; i < icons.length; ++i) {
            if (icons[i] == null) continue;
            this.width = icons[i].getIconWidth();
            this.height = icons[i].getIconHeight();
            break;
        }
        this.generateMissingIcons();
    }

    private void generateMissingIcons() {
        if (this.icons[1] == null) {
            this.icons[1] = this.icons[0];
        }
        if (this.icons[2] == null) {
            this.icons[2] = this.icons[1];
        }
        if (this.icons[3] == null) {
            this.icons[3] = this.icons[1];
        }
        if (this.icons[4] == null) {
            this.icons[4] = this.icons[0];
        }
        if (this.icons[5] == null) {
            this.icons[5] = this.icons[2];
        }
        if (this.icons[6] == null) {
            this.icons[6] = this.icons[0];
        }
        if (this.icons[7] == null) {
            this.icons[7] = this.icons[2];
        }
        if (this.icons[8] == null) {
            this.icons[8] = this.icons[4];
        }
        if (this.icons[9] == null) {
            this.icons[9] = this.icons[5];
        }
    }

    public int getIconHeight() {
        return this.height;
    }

    public int getIconWidth() {
        return this.width;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Icon icon = this.getIcon(c);
        if (icon != null) {
            icon.paintIcon(c, g, x, y);
        }
    }

    private Icon getIcon(Component c) {
        Icon icon;
        boolean isActive = QuaquaUtilities.isOnActiveWindow(c);
        if (c instanceof AbstractButton) {
            ButtonModel model = ((AbstractButton)c).getModel();
            icon = isActive ? (model.isEnabled() ? (model.isPressed() || model.isArmed() ? (model.isSelected() ? this.icons[3] : this.icons[1]) : (model.isSelected() ? this.icons[2] : this.icons[0])) : (model.isSelected() ? this.icons[5] : this.icons[4])) : (model.isEnabled() ? (model.isSelected() ? this.icons[7] : this.icons[6]) : (model.isSelected() ? this.icons[9] : this.icons[8]));
        } else {
            icon = isActive ? (c.isEnabled() ? this.icons[0] : this.icons[4]) : (c.isEnabled() ? this.icons[6] : this.icons[8]);
        }
        return icon;
    }
}

