/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicDirectoryModel;
import javax.swing.plaf.basic.BasicFileChooserUI;
import org.jvnet.substance.SubstanceGradientBackgroundDelegate;
import org.jvnet.substance.SubstanceLookAndFeel;
import sun.awt.shell.ShellFolder;
import sun.swing.FilePane;

public class SubstanceFileChooserUI
extends BasicFileChooserUI {
    private JComboBox directoryComboBox;
    private DirectoryComboBoxModel directoryComboBoxModel;
    private Action directoryComboBoxAction = new DirectoryComboBoxAction();
    private FilterComboBoxModel filterComboBoxModel;
    private JTextField fileNameTextField;
    private FilePane filePane;
    private JToggleButton listViewButton;
    private JToggleButton detailsViewButton;
    private boolean useShellFolder;
    private JButton approveButton;
    private JButton cancelButton;
    private JComboBox filterComboBox;
    private static final Insets shrinkwrap = new Insets(0, 0, 0, 0);
    private static int PREF_WIDTH = 500;
    private static int PREF_HEIGHT = 326;
    private static Dimension PREF_SIZE = new Dimension(PREF_WIDTH, PREF_HEIGHT);
    private static int MIN_WIDTH = 500;
    private static int MIN_HEIGHT = 326;
    private static Dimension MIN_SIZE = new Dimension(MIN_WIDTH, MIN_HEIGHT);
    private static int LIST_PREF_WIDTH = 405;
    private static int LIST_PREF_HEIGHT = 135;
    private static Dimension LIST_PREF_SIZE = new Dimension(LIST_PREF_WIDTH, LIST_PREF_HEIGHT);
    private String fileNameLabelText = null;
    private String filesOfTypeLabelText = null;
    static final int space = 10;

    public static ComponentUI createUI(JComponent c) {
        return new SubstanceFileChooserUI((JFileChooser)c);
    }

    public SubstanceFileChooserUI(JFileChooser filechooser) {
        super(filechooser);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
    }

    public void uninstallComponents(JFileChooser fc) {
        fc.removeAll();
    }

    public void installComponents(JFileChooser fc) {
        FileSystemView fsv = fc.getFileSystemView();
        fc.setBorder(new EmptyBorder(12, 12, 11, 11));
        fc.setLayout(new BorderLayout(0, 11));
        this.filePane = new FilePane(new SubstanceFileChooserUIAccessor());
        fc.addPropertyChangeListener(this.filePane);
        this.updateUseShellFolder();
        JPanel topPanel = new JPanel(new BorderLayout(11, 0));
        JPanel topButtonPanel = new JPanel();
        topButtonPanel.setLayout(new BoxLayout(topButtonPanel, 2));
        topPanel.add((Component)topButtonPanel, "Before");
        fc.add((Component)topPanel, "North");
        this.directoryComboBox = new JComboBox(){

            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.width = 150;
                return d;
            }
        };
        this.directoryComboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(fc);
        this.directoryComboBox.setModel(this.directoryComboBoxModel);
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(fc));
        this.directoryComboBox.setAlignmentX(0.0f);
        this.directoryComboBox.setAlignmentY(0.0f);
        this.directoryComboBox.setMaximumRowCount(8);
        topPanel.add((Component)this.directoryComboBox, "Center");
        JButton upFolderButton = new JButton(this.getChangeToParentDirectoryAction());
        upFolderButton.setText(null);
        upFolderButton.setIcon(this.upFolderIcon);
        upFolderButton.setAlignmentX(0.0f);
        upFolderButton.setAlignmentY(0.5f);
        upFolderButton.setMargin(shrinkwrap);
        topButtonPanel.add(upFolderButton);
        topButtonPanel.add(Box.createRigidArea(new Dimension(5, 1)));
        File homeDir = fsv.getHomeDirectory();
        JButton b = new JButton(this.homeFolderIcon);
        b.setAlignmentX(0.0f);
        b.setAlignmentY(0.5f);
        b.setMargin(shrinkwrap);
        b.addActionListener(this.getGoHomeAction());
        topButtonPanel.add(b);
        topButtonPanel.add(Box.createRigidArea(new Dimension(5, 1)));
        if (!UIManager.getBoolean("FileChooser.readOnly")) {
            b = new JButton(this.filePane.getNewFolderAction());
            b.setText(null);
            b.setIcon(this.newFolderIcon);
            b.setAlignmentX(0.0f);
            b.setAlignmentY(0.5f);
            b.setMargin(shrinkwrap);
        }
        topButtonPanel.add(b);
        topButtonPanel.add(Box.createRigidArea(new Dimension(5, 1)));
        ButtonGroup viewButtonGroup = new ButtonGroup();
        this.listViewButton = new JToggleButton(this.listViewIcon);
        this.listViewButton.setSelected(true);
        this.listViewButton.setAlignmentX(0.0f);
        this.listViewButton.setAlignmentY(0.5f);
        this.listViewButton.setMargin(shrinkwrap);
        this.listViewButton.addActionListener(this.filePane.getViewTypeAction(0));
        topButtonPanel.add(this.listViewButton);
        viewButtonGroup.add(this.listViewButton);
        this.detailsViewButton = new JToggleButton(this.detailsViewIcon);
        this.detailsViewButton.setAlignmentX(0.0f);
        this.detailsViewButton.setAlignmentY(0.5f);
        this.detailsViewButton.setMargin(shrinkwrap);
        this.detailsViewButton.addActionListener(this.filePane.getViewTypeAction(1));
        topButtonPanel.add(this.detailsViewButton);
        viewButtonGroup.add(this.detailsViewButton);
        fc.add((Component)this.getAccessoryPanel(), "After");
        JComponent accessory = fc.getAccessory();
        if (accessory != null) {
            this.getAccessoryPanel().add(accessory);
        }
        this.filePane.setPreferredSize(LIST_PREF_SIZE);
        fc.add((Component)this.filePane, "Center");
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 1));
        fc.add((Component)bottomPanel, "South");
        JPanel fileNamePanel = new JPanel();
        fileNamePanel.setLayout(new BoxLayout(fileNamePanel, 2));
        bottomPanel.add(fileNamePanel);
        bottomPanel.add(Box.createRigidArea(new Dimension(1, 5)));
        AlignedLabel fileNameLabel = new AlignedLabel(this.fileNameLabelText);
        fileNamePanel.add(fileNameLabel);
        this.fileNameTextField = new JTextField(35){

            public Dimension getMaximumSize() {
                return new Dimension(Short.MAX_VALUE, super.getPreferredSize().height);
            }
        };
        fileNamePanel.add(this.fileNameTextField);
        fileNameLabel.setLabelFor(this.fileNameTextField);
        this.fileNameTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (!SubstanceFileChooserUI.this.getFileChooser().isMultiSelectionEnabled()) {
                    SubstanceFileChooserUI.this.filePane.clearSelection();
                }
            }
        });
        if (fc.isMultiSelectionEnabled()) {
            this.setFileName(this.fileNameString(fc.getSelectedFiles()));
        } else {
            this.setFileName(this.fileNameString(fc.getSelectedFile()));
        }
        this.approveButton = new JButton(this.getApproveButtonText(fc));
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        fileNamePanel.add(Box.createRigidArea(new Dimension(12, 1)));
        fileNamePanel.add(this.approveButton);
        JPanel filesOfTypePanel = new JPanel();
        filesOfTypePanel.setLayout(new BoxLayout(filesOfTypePanel, 2));
        bottomPanel.add(filesOfTypePanel);
        AlignedLabel filesOfTypeLabel = new AlignedLabel(this.filesOfTypeLabelText);
        filesOfTypePanel.add(filesOfTypeLabel);
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        fc.addPropertyChangeListener(this.filterComboBoxModel);
        this.filterComboBox = new JComboBox(this.filterComboBoxModel);
        this.filterComboBox.getAccessibleContext().setAccessibleDescription(this.filesOfTypeLabelText);
        filesOfTypeLabel.setLabelFor(this.filterComboBox);
        this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer());
        filesOfTypePanel.add(this.filterComboBox);
        filesOfTypePanel.add(Box.createRigidArea(new Dimension(12, 1)));
        this.cancelButton = new JButton(this.cancelButtonText);
        this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        filesOfTypePanel.add(this.cancelButton);
        SubstanceFileChooserUI.groupLabels(new AlignedLabel[]{fileNameLabel, filesOfTypeLabel});
    }

    private void updateUseShellFolder() {
        JFileChooser fc = this.getFileChooser();
        Boolean prop = (Boolean)fc.getClientProperty("FileChooser.useShellFolder");
        if (prop != null) {
            this.useShellFolder = prop;
        } else {
            File[] cbFolders;
            this.useShellFolder = false;
            File[] roots = fc.getFileSystemView().getRoots();
            if (roots != null && roots.length == 1 && (cbFolders = (File[])ShellFolder.get("fileChooserComboBoxFolders")) != null && cbFolders.length > 0 && roots[0] == cbFolders[0]) {
                this.useShellFolder = true;
            }
        }
    }

    protected void installStrings(JFileChooser fc) {
        super.installStrings(fc);
        Locale l = fc.getLocale();
        this.fileNameLabelText = UIManager.getString((Object)"FileChooser.fileNameLabelText", l);
        this.filesOfTypeLabelText = UIManager.getString((Object)"FileChooser.filesOfTypeLabelText", l);
    }

    protected void installListeners(JFileChooser fc) {
        super.installListeners(fc);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(fc, actionMap);
    }

    protected ActionMap getActionMap() {
        return this.createActionMap();
    }

    protected ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        FilePane.addActionsToMap(map, this.filePane.getActions());
        return map;
    }

    protected JPanel createList(JFileChooser fc) {
        return this.filePane.createList();
    }

    protected JPanel createDetailsView(JFileChooser fc) {
        return this.filePane.createDetailsView();
    }

    public ListSelectionListener createListSelectionListener(JFileChooser fc) {
        return super.createListSelectionListener(fc);
    }

    public void uninstallUI(JComponent c) {
        c.removePropertyChangeListener(this.filterComboBoxModel);
        c.removePropertyChangeListener(this.filePane);
        this.cancelButton.removeActionListener(this.getCancelSelectionAction());
        this.approveButton.removeActionListener(this.getApproveSelectionAction());
        this.fileNameTextField.removeActionListener(this.getApproveSelectionAction());
        super.uninstallUI(c);
    }

    public Dimension getPreferredSize(JComponent c) {
        int prefWidth = SubstanceFileChooserUI.PREF_SIZE.width;
        Dimension d = c.getLayout().preferredLayoutSize(c);
        if (d != null) {
            return new Dimension(d.width < prefWidth ? prefWidth : d.width, d.height < SubstanceFileChooserUI.PREF_SIZE.height ? SubstanceFileChooserUI.PREF_SIZE.height : d.height);
        }
        return new Dimension(prefWidth, SubstanceFileChooserUI.PREF_SIZE.height);
    }

    public Dimension getMinimumSize(JComponent c) {
        return MIN_SIZE;
    }

    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    private String fileNameString(File file) {
        if (file == null) {
            return null;
        }
        JFileChooser fc = this.getFileChooser();
        if (fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled()) {
            return file.getPath();
        }
        return file.getName();
    }

    private String fileNameString(File[] files) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; files != null && i < files.length; ++i) {
            if (i > 0) {
                buf.append(" ");
            }
            if (files.length > 1) {
                buf.append("\"");
            }
            buf.append(this.fileNameString(files[i]));
            if (files.length <= 1) continue;
            buf.append("\"");
        }
        return buf.toString();
    }

    private void doSelectedFileChanged(PropertyChangeEvent e) {
        File f = (File)e.getNewValue();
        JFileChooser fc = this.getFileChooser();
        if (f != null && (fc.isFileSelectionEnabled() && !f.isDirectory() || f.isDirectory() && fc.isDirectorySelectionEnabled())) {
            this.setFileName(this.fileNameString(f));
        }
    }

    private void doSelectedFilesChanged(PropertyChangeEvent e) {
        File[] files = (File[])e.getNewValue();
        JFileChooser fc = this.getFileChooser();
        if (files != null && files.length > 0 && (files.length > 1 || fc.isDirectorySelectionEnabled() || !files[0].isDirectory())) {
            this.setFileName(this.fileNameString(files));
        }
    }

    private void doDirectoryChanged(PropertyChangeEvent e) {
        JFileChooser fc = this.getFileChooser();
        FileSystemView fsv = fc.getFileSystemView();
        this.clearIconCache();
        File currentDirectory = fc.getCurrentDirectory();
        if (currentDirectory != null) {
            this.directoryComboBoxModel.addItem(currentDirectory);
            if (fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled()) {
                if (fsv.isFileSystem(currentDirectory)) {
                    this.setFileName(currentDirectory.getPath());
                } else {
                    this.setFileName(null);
                }
            }
        }
    }

    private void doFilterChanged(PropertyChangeEvent e) {
        this.clearIconCache();
    }

    private void doFileSelectionModeChanged(PropertyChangeEvent e) {
        this.clearIconCache();
        JFileChooser fc = this.getFileChooser();
        File currentDirectory = fc.getCurrentDirectory();
        if (currentDirectory != null && fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled() && fc.getFileSystemView().isFileSystem(currentDirectory)) {
            this.setFileName(currentDirectory.getPath());
        } else {
            this.setFileName(null);
        }
    }

    private void doAccessoryChanged(PropertyChangeEvent e) {
        if (this.getAccessoryPanel() != null) {
            JComponent accessory;
            if (e.getOldValue() != null) {
                this.getAccessoryPanel().remove((JComponent)e.getOldValue());
            }
            if ((accessory = (JComponent)e.getNewValue()) != null) {
                this.getAccessoryPanel().add((Component)accessory, "Center");
            }
        }
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser fc) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String s = e.getPropertyName();
                if (s.equals("SelectedFileChangedProperty")) {
                    SubstanceFileChooserUI.this.doSelectedFileChanged(e);
                } else if (s.equals("SelectedFilesChangedProperty")) {
                    SubstanceFileChooserUI.this.doSelectedFilesChanged(e);
                } else if (s.equals("directoryChanged")) {
                    SubstanceFileChooserUI.this.doDirectoryChanged(e);
                } else if (s.equals("fileFilterChanged")) {
                    SubstanceFileChooserUI.this.doFilterChanged(e);
                } else if (s.equals("fileSelectionChanged")) {
                    SubstanceFileChooserUI.this.doFileSelectionModeChanged(e);
                } else if (s.equals("AccessoryChangedProperty")) {
                    SubstanceFileChooserUI.this.doAccessoryChanged(e);
                } else if (s.equals("componentOrientation")) {
                    ComponentOrientation o = (ComponentOrientation)e.getNewValue();
                    JFileChooser cc = (JFileChooser)e.getSource();
                    if (o != (ComponentOrientation)e.getOldValue()) {
                        cc.applyComponentOrientation(o);
                    }
                } else if (s == "FileChooser.useShellFolder") {
                    SubstanceFileChooserUI.this.updateUseShellFolder();
                    SubstanceFileChooserUI.this.doDirectoryChanged(e);
                } else if (s.equals("ancestor") && e.getOldValue() == null && e.getNewValue() != null) {
                    SubstanceFileChooserUI.this.fileNameTextField.selectAll();
                    SubstanceFileChooserUI.this.fileNameTextField.requestFocus();
                }
            }
        };
    }

    public void ensureFileIsVisible(JFileChooser fc, File f) {
        this.filePane.ensureFileIsVisible(fc, f);
    }

    public void rescanCurrentDirectory(JFileChooser fc) {
        this.filePane.rescanCurrentDirectory();
    }

    public String getFileName() {
        if (this.fileNameTextField != null) {
            return this.fileNameTextField.getText();
        }
        return null;
    }

    public void setFileName(String filename) {
        if (this.fileNameTextField != null) {
            this.fileNameTextField.setText(filename);
        }
    }

    protected void setDirectorySelected(boolean directorySelected) {
        super.setDirectorySelected(directorySelected);
        JFileChooser chooser = this.getFileChooser();
        if (directorySelected) {
            if (this.approveButton != null) {
                this.approveButton.setText(this.directoryOpenButtonText);
                this.approveButton.setToolTipText(this.directoryOpenButtonToolTipText);
            }
        } else if (this.approveButton != null) {
            this.approveButton.setText(this.getApproveButtonText(chooser));
            this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
        }
    }

    public String getDirectoryName() {
        return null;
    }

    public void setDirectoryName(String dirname) {
    }

    protected DirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JFileChooser fc) {
        return new DirectoryComboBoxRenderer();
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser fc) {
        return new DirectoryComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    public void valueChanged(ListSelectionEvent e) {
        JFileChooser fc = this.getFileChooser();
        File f = fc.getSelectedFile();
        if (!e.getValueIsAdjusting() && f != null && !this.getFileChooser().isTraversable(f)) {
            this.setFileName(this.fileNameString(f));
        }
    }

    protected JButton getApproveButton(JFileChooser fc) {
        return this.approveButton;
    }

    private static void groupLabels(AlignedLabel[] group) {
        for (int i = 0; i < group.length; ++i) {
            AlignedLabel.access$1702(group[i], group);
        }
    }

    private class AlignedLabel
    extends JLabel {
        private AlignedLabel[] group;
        private int maxWidth;

        AlignedLabel(String text) {
            super(text);
            this.maxWidth = 0;
            this.setAlignmentX(0.0f);
        }

        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            return new Dimension(this.getMaxWidth() + 11, d.height);
        }

        private int getMaxWidth() {
            if (this.maxWidth == 0 && this.group != null) {
                int i;
                int max = 0;
                for (i = 0; i < this.group.length; ++i) {
                    max = Math.max(this.group[i].getSuperPreferredWidth(), max);
                }
                for (i = 0; i < this.group.length; ++i) {
                    this.group[i].maxWidth = max;
                }
            }
            return this.maxWidth;
        }

        private int getSuperPreferredWidth() {
            return super.getPreferredSize().width;
        }

        static /* synthetic */ AlignedLabel[] access$1702(AlignedLabel x0, AlignedLabel[] x1) {
            x0.group = x1;
            return x1;
        }
    }

    private static class ButtonAreaLayout
    implements LayoutManager {
        private int hGap = 5;
        private int topMargin = 17;

        private ButtonAreaLayout() {
        }

        public void addLayoutComponent(String string, Component comp) {
        }

        public void layoutContainer(Container container) {
            Component[] children = container.getComponents();
            if (children != null && children.length > 0) {
                int xOffset;
                int xLocation;
                int numChildren = children.length;
                Dimension[] sizes = new Dimension[numChildren];
                Insets insets = container.getInsets();
                int yLocation = insets.top + this.topMargin;
                int maxWidth = 0;
                for (int counter = 0; counter < numChildren; ++counter) {
                    sizes[counter] = children[counter].getPreferredSize();
                    maxWidth = Math.max(maxWidth, sizes[counter].width);
                }
                if (container.getComponentOrientation().isLeftToRight()) {
                    xLocation = container.getSize().width - insets.left - maxWidth;
                    xOffset = this.hGap + maxWidth;
                } else {
                    xLocation = insets.left;
                    xOffset = -(this.hGap + maxWidth);
                }
                for (int counter = numChildren - 1; counter >= 0; --counter) {
                    children[counter].setBounds(xLocation, yLocation, maxWidth, sizes[counter].height);
                    xLocation -= xOffset;
                }
            }
        }

        public Dimension minimumLayoutSize(Container c) {
            Component[] children;
            if (c != null && (children = c.getComponents()) != null && children.length > 0) {
                int numChildren = children.length;
                int height = 0;
                Insets cInsets = c.getInsets();
                int extraHeight = this.topMargin + cInsets.top + cInsets.bottom;
                int extraWidth = cInsets.left + cInsets.right;
                int maxWidth = 0;
                for (int counter = 0; counter < numChildren; ++counter) {
                    Dimension aSize = children[counter].getPreferredSize();
                    height = Math.max(height, aSize.height);
                    maxWidth = Math.max(maxWidth, aSize.width);
                }
                return new Dimension(extraWidth + numChildren * maxWidth + (numChildren - 1) * this.hGap, extraHeight + height);
            }
            return new Dimension(0, 0);
        }

        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        public void removeLayoutComponent(Component c) {
        }
    }

    protected class DirectoryComboBoxAction
    extends AbstractAction {
        protected DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
        }

        public void actionPerformed(ActionEvent e) {
            SubstanceFileChooserUI.this.directoryComboBox.hidePopup();
            File f = (File)SubstanceFileChooserUI.this.directoryComboBox.getSelectedItem();
            if (!SubstanceFileChooserUI.this.getFileChooser().getCurrentDirectory().equals(f)) {
                SubstanceFileChooserUI.this.getFileChooser().setCurrentDirectory(f);
            }
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters;

        protected FilterComboBoxModel() {
            this.filters = SubstanceFileChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])e.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (prop == "fileFilterChanged") {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void setSelectedItem(Object filter) {
            if (filter != null) {
                SubstanceFileChooserUI.this.getFileChooser().setFileFilter((FileFilter)filter);
                SubstanceFileChooserUI.this.setFileName(null);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            FileFilter currentFilter = SubstanceFileChooserUI.this.getFileChooser().getFileFilter();
            boolean found = false;
            if (currentFilter != null) {
                for (int i = 0; i < this.filters.length; ++i) {
                    if (this.filters[i] != currentFilter) continue;
                    found = true;
                }
                if (!found) {
                    SubstanceFileChooserUI.this.getFileChooser().addChoosableFileFilter(currentFilter);
                }
            }
            return SubstanceFileChooserUI.this.getFileChooser().getFileFilter();
        }

        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        public Object getElementAt(int index) {
            if (index > this.getSize() - 1) {
                return SubstanceFileChooserUI.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[index];
            }
            return null;
        }
    }

    public class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        private boolean isSelected;
        private SubstanceGradientBackgroundDelegate backgroundDelegate = new SubstanceGradientBackgroundDelegate();

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.isSelected = isSelected;
            if (value != null && value instanceof FileFilter) {
                this.setText(((FileFilter)value).getDescription());
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void paintComponent(Graphics g) {
            if (this.isSelected) {
                FilterComboBoxRenderer filterComboBoxRenderer = this;
                synchronized (filterComboBoxRenderer) {
                    boolean oldOpaque = this.isOpaque();
                    this.setOpaque(false);
                    this.backgroundDelegate.update(g, this, this.getWidth(), this.getHeight(), SubstanceLookAndFeel.getColorScheme(), true);
                    super.paintComponent(g);
                    this.setOpaque(oldOpaque);
                }
            } else {
                super.paintComponent(g);
            }
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        Vector<File> directories = new Vector();
        int[] depths = null;
        File selectedDirectory = null;
        JFileChooser chooser = SubstanceFileChooserUI.this.getFileChooser();
        FileSystemView fsv = this.chooser.getFileSystemView();

        public DirectoryComboBoxModel() {
            File dir = SubstanceFileChooserUI.this.getFileChooser().getCurrentDirectory();
            if (dir != null) {
                this.addItem(dir);
            }
        }

        private void addItem(File directory) {
            if (directory == null) {
                return;
            }
            this.directories.clear();
            File[] baseFolders = SubstanceFileChooserUI.this.useShellFolder ? (File[])ShellFolder.get("fileChooserComboBoxFolders") : this.fsv.getRoots();
            this.directories.addAll(Arrays.asList(baseFolders));
            File canonical = null;
            try {
                canonical = directory.getCanonicalFile();
            }
            catch (IOException e) {
                canonical = directory;
            }
            try {
                File sf;
                File f = sf = SubstanceFileChooserUI.this.useShellFolder ? ShellFolder.getShellFolder(canonical) : canonical;
                Vector<File> path = new Vector<File>(10);
                do {
                    path.addElement(f);
                } while ((f = f.getParentFile()) != null);
                int pathCount = path.size();
                for (int i = 0; i < pathCount; ++i) {
                    f = (File)path.get(i);
                    if (!this.directories.contains(f)) continue;
                    int topIndex = this.directories.indexOf(f);
                    for (int j = i - 1; j >= 0; --j) {
                        this.directories.insertElementAt((File)path.get(j), topIndex + i - j);
                    }
                    break;
                }
                this.calculateDepths();
                this.setSelectedItem(sf);
            }
            catch (FileNotFoundException ex) {
                this.calculateDepths();
            }
        }

        private void calculateDepths() {
            this.depths = new int[this.directories.size()];
            block0: for (int i = 0; i < this.depths.length; ++i) {
                File dir = this.directories.get(i);
                File parent = dir.getParentFile();
                this.depths[i] = 0;
                if (parent == null) continue;
                for (int j = i - 1; j >= 0; --j) {
                    if (!parent.equals(this.directories.get(j))) continue;
                    this.depths[i] = this.depths[j] + 1;
                    continue block0;
                }
            }
        }

        public int getDepth(int i) {
            return this.depths != null && i >= 0 && i < this.depths.length ? this.depths[i] : 0;
        }

        public void setSelectedItem(Object selectedDirectory) {
            this.selectedDirectory = (File)selectedDirectory;
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        public int getSize() {
            return this.directories.size();
        }

        public Object getElementAt(int index) {
            return this.directories.elementAt(index);
        }
    }

    class OffsetIcon
    implements Icon {
        Icon icon = null;
        int depth = 0;

        OffsetIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (c.getComponentOrientation().isLeftToRight()) {
                this.icon.paintIcon(c, g, x + this.depth * 10, y);
            } else {
                this.icon.paintIcon(c, g, x, y);
            }
        }

        public int getIconWidth() {
            return this.icon.getIconWidth() + this.depth * 10;
        }

        public int getIconHeight() {
            return this.icon.getIconHeight();
        }
    }

    class DirectoryComboBoxRenderer
    extends DefaultListCellRenderer {
        OffsetIcon offsetIcon;
        private boolean isSelected;
        private SubstanceGradientBackgroundDelegate backgroundDelegate;

        DirectoryComboBoxRenderer() {
            this.offsetIcon = new OffsetIcon();
            this.backgroundDelegate = new SubstanceGradientBackgroundDelegate();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Icon icon;
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.isSelected = isSelected;
            if (value == null) {
                this.setText("");
                return this;
            }
            File directory = (File)value;
            this.setText(SubstanceFileChooserUI.this.getFileChooser().getName(directory));
            this.offsetIcon.icon = icon = SubstanceFileChooserUI.this.getFileChooser().getIcon(directory);
            this.offsetIcon.depth = SubstanceFileChooserUI.this.directoryComboBoxModel.getDepth(index);
            this.setIcon(this.offsetIcon);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void paintComponent(Graphics g) {
            if (this.isSelected) {
                DirectoryComboBoxRenderer directoryComboBoxRenderer = this;
                synchronized (directoryComboBoxRenderer) {
                    boolean oldOpaque = this.isOpaque();
                    this.setOpaque(false);
                    this.backgroundDelegate.update(g, this, this.getWidth(), this.getHeight(), SubstanceLookAndFeel.getColorScheme(), true);
                    super.paintComponent(g);
                    this.setOpaque(oldOpaque);
                }
            } else {
                super.paintComponent(g);
            }
        }
    }

    private class SubstanceFileChooserUIAccessor
    implements FilePane.FileChooserUIAccessor {
        private SubstanceFileChooserUIAccessor() {
        }

        public JFileChooser getFileChooser() {
            return SubstanceFileChooserUI.this.getFileChooser();
        }

        public BasicDirectoryModel getModel() {
            return SubstanceFileChooserUI.this.getModel();
        }

        public JPanel createList() {
            return SubstanceFileChooserUI.this.createList(this.getFileChooser());
        }

        public JPanel createDetailsView() {
            return SubstanceFileChooserUI.this.createDetailsView(this.getFileChooser());
        }

        public boolean isDirectorySelected() {
            return SubstanceFileChooserUI.this.isDirectorySelected();
        }

        public File getDirectory() {
            return SubstanceFileChooserUI.this.getDirectory();
        }

        public Action getChangeToParentDirectoryAction() {
            return SubstanceFileChooserUI.this.getChangeToParentDirectoryAction();
        }

        public Action getApproveSelectionAction() {
            return SubstanceFileChooserUI.this.getApproveSelectionAction();
        }

        public Action getNewFolderAction() {
            return SubstanceFileChooserUI.this.getNewFolderAction();
        }

        public MouseListener createDoubleClickListener(JList list) {
            return SubstanceFileChooserUI.this.createDoubleClickListener(this.getFileChooser(), list);
        }

        public ListSelectionListener createListSelectionListener() {
            return SubstanceFileChooserUI.this.createListSelectionListener(this.getFileChooser());
        }
    }
}

