/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicDesktopIconUI;
import org.jvnet.substance.SubstanceBackgroundDelegate;
import org.jvnet.substance.SubstanceButtonUI;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceInternalFrameTitlePane;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.color.ColorSchemeEnum;

public class SubstanceDesktopIconUI
extends BasicDesktopIconUI {
    private JButton restoreButton;
    private JButton maximizeButton;
    private JButton closeButton;
    private JLabel iconLabel;
    private JLabel titleLabel;
    private TitleListener titleListener;
    private MouseInputListener labelMouseInputListener;
    private int width;
    private JWindow previewWindow;
    private boolean isInDrag;

    public static ComponentUI createUI(JComponent c) {
        return new SubstanceDesktopIconUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        Font f = this.desktopIcon.getFont();
        if (f == null || f instanceof UIResource) {
            this.desktopIcon.setFont(UIManager.getFont("DesktopIcon.font"));
        }
        this.width = UIManager.getInt("DesktopIcon.width");
        this.desktopIcon.setBackground(SubstanceLookAndFeel.getColorScheme().getColorScheme().getExtraLightColor());
    }

    protected void installComponents() {
        this.frame = this.desktopIcon.getInternalFrame();
        this.frame.setOpaque(false);
        Icon icon = this.frame.getFrameIcon();
        this.previewWindow = new JWindow();
        this.previewWindow.getContentPane().setLayout(new BorderLayout());
        this.titleLabel = new JLabel(this.frame.getTitle());
        this.desktopIcon.add(this.titleLabel);
        this.titleLabel.setToolTipText(this.frame.getTitle());
        this.titleLabel.setFont(this.desktopIcon.getFont());
        this.isInDrag = false;
        this.titleLabel.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                if (SubstanceDesktopIconUI.this.isInDrag) {
                    return;
                }
                BufferedImage previewImage = SubstanceInternalFrameTitlePane.getSnapshot(SubstanceDesktopIconUI.this.frame);
                if (previewImage != null) {
                    SubstanceDesktopIconUI.this.previewWindow.getContentPane().removeAll();
                    SubstanceDesktopIconUI.this.previewWindow.getContentPane().add((Component)new JLabel(new ImageIcon(previewImage)), "Center");
                    SubstanceDesktopIconUI.this.previewWindow.setSize(previewImage.getWidth(), previewImage.getHeight());
                    SubstanceDesktopIconUI.this.syncPreviewWindow(true);
                    SubstanceDesktopIconUI.this.previewWindow.setVisible(true);
                }
            }

            public void mouseExited(MouseEvent e) {
                SubstanceDesktopIconUI.this.isInDrag = false;
                SubstanceDesktopIconUI.this.previewWindow.setVisible(false);
            }

            public void mousePressed(MouseEvent e) {
                SubstanceDesktopIconUI.this.previewWindow.setVisible(false);
            }

            public void mouseReleased(MouseEvent e) {
                SubstanceDesktopIconUI.this.isInDrag = false;
                SubstanceDesktopIconUI.this.syncPreviewWindow(true);
                SubstanceDesktopIconUI.this.previewWindow.setVisible(true);
            }
        });
        this.titleLabel.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                SubstanceDesktopIconUI.this.isInDrag = true;
                if (SubstanceDesktopIconUI.this.previewWindow.isVisible()) {
                    SubstanceDesktopIconUI.this.syncPreviewWindow(false);
                    SubstanceDesktopIconUI.this.previewWindow.setVisible(false);
                }
            }
        });
        this.iconLabel = new JLabel(icon);
        this.iconLabel.setOpaque(false);
        this.desktopIcon.add(this.iconLabel);
        this.restoreButton = new JButton(SubstanceImageCreator.getRestoreIcon(SubstanceLookAndFeel.getColorScheme()));
        this.restoreButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SubstanceDesktopIconUI.this.previewWindow.setVisible(false);
                SubstanceDesktopIconUI.this.deiconize();
            }
        });
        this.desktopIcon.add(this.restoreButton);
        this.addClickCorrectionListener(this.restoreButton);
        this.maximizeButton = new JButton(SubstanceImageCreator.getMaximizeIcon(SubstanceLookAndFeel.getColorScheme()));
        this.maximizeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SubstanceDesktopIconUI.this.previewWindow.setVisible(false);
                try {
                    if (SubstanceDesktopIconUI.this.frame.isMaximum()) {
                        SubstanceDesktopIconUI.this.frame.setIcon(false);
                    } else {
                        SubstanceDesktopIconUI.this.frame.setMaximum(true);
                    }
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        });
        this.desktopIcon.add(this.maximizeButton);
        this.addClickCorrectionListener(this.maximizeButton);
        this.closeButton = new JButton(SubstanceImageCreator.getCloseIcon(SubstanceLookAndFeel.getColorScheme()));
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    SubstanceDesktopIconUI.this.frame.setClosed(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        });
        this.desktopIcon.add(this.closeButton);
        SubstanceBackgroundDelegate.trackTitleButton(this.restoreButton, SubstanceButtonUI.ButtonTitleKind.REGULAR_DI);
        SubstanceBackgroundDelegate.trackTitleButton(this.maximizeButton, SubstanceButtonUI.ButtonTitleKind.REGULAR_DI);
        SubstanceBackgroundDelegate.trackTitleButton(this.closeButton, SubstanceButtonUI.ButtonTitleKind.CLOSE_DI);
        this.desktopIcon.setLayout(new DesktopPaneLayout());
        this.desktopIcon.add(this.restoreButton);
        this.desktopIcon.add(this.maximizeButton);
        this.desktopIcon.add(this.closeButton);
        this.iconLabel.setOpaque(false);
        this.restoreButton.setOpaque(false);
        this.maximizeButton.setOpaque(false);
        this.closeButton.setOpaque(false);
        this.desktopIcon.setOpaque(false);
    }

    protected void uninstallComponents() {
        this.desktopIcon.setLayout(null);
        this.desktopIcon.remove(this.iconLabel);
        this.desktopIcon.remove(this.restoreButton);
        this.desktopIcon.remove(this.maximizeButton);
        this.desktopIcon.remove(this.closeButton);
        this.removeClickCorrectionListener(this.restoreButton);
        this.removeClickCorrectionListener(this.maximizeButton);
        this.restoreButton = null;
        this.maximizeButton = null;
        this.closeButton = null;
        this.frame = null;
    }

    protected void installListeners() {
        super.installListeners();
        this.titleListener = new TitleListener();
        this.desktopIcon.getInternalFrame().addPropertyChangeListener(this.titleListener);
        this.labelMouseInputListener = this.createMouseInputListener();
        this.titleLabel.addMouseMotionListener(this.labelMouseInputListener);
        this.titleLabel.addMouseListener(this.labelMouseInputListener);
    }

    protected void uninstallListeners() {
        this.desktopIcon.getInternalFrame().removePropertyChangeListener(this.titleListener);
        this.titleListener = null;
        this.titleLabel.removeMouseMotionListener(this.labelMouseInputListener);
        this.titleLabel.removeMouseListener(this.labelMouseInputListener);
        this.labelMouseInputListener = null;
        super.uninstallListeners();
    }

    public Dimension getPreferredSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    public Dimension getMinimumSize(JComponent c) {
        return new Dimension(this.width, this.desktopIcon.getLayout().minimumLayoutSize((Container)this.desktopIcon).height);
    }

    public Dimension getMaximumSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    private void addClickCorrectionListener(JButton button) {
        for (ActionListener listener : button.getActionListeners()) {
            if (!(listener instanceof SubstanceInternalFrameTitlePane.ClickListener)) continue;
            return;
        }
        button.addActionListener(new SubstanceInternalFrameTitlePane.ClickListener());
    }

    private void removeClickCorrectionListener(JButton button) {
        ActionListener[] actionListeners;
        for (ActionListener actionListener : actionListeners = button.getActionListeners()) {
            if (!(actionListener instanceof SubstanceInternalFrameTitlePane.ClickListener)) continue;
            button.removeActionListener(actionListener);
        }
    }

    public void paint(Graphics g, JComponent c) {
        JInternalFrame.JDesktopIcon di = (JInternalFrame.JDesktopIcon)c;
        di.setOpaque(false);
        int width = di.getWidth();
        int height = di.getHeight();
        ColorSchemeEnum colorSchemeEnum = SubstanceLookAndFeel.getColorScheme();
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setComposite(AlphaComposite.getInstance(10, 0.6f));
        graphics.drawImage((Image)SubstanceImageCreator.getRectangularBackground(width, height, colorSchemeEnum, false), 0, 0, null);
        di.paintComponents(graphics);
        graphics.dispose();
    }

    public void update(Graphics g, JComponent c) {
        this.paint(g, c);
    }

    private void syncPreviewWindow(boolean toShow) {
        if (toShow) {
            int x = this.desktopIcon.getLocationOnScreen().x;
            int y = this.desktopIcon.getLocationOnScreen().y;
            this.previewWindow.setLocation(x, y - this.previewWindow.getHeight());
        }
    }

    private class DesktopPaneLayout
    implements LayoutManager {
        private DesktopPaneLayout() {
        }

        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            int height = this.computeHeight();
            return new Dimension(height, height);
        }

        private int computeHeight() {
            FontMetrics fm = SubstanceDesktopIconUI.this.desktopIcon.getFontMetrics(SubstanceDesktopIconUI.this.desktopIcon.getFont());
            int fontHeight = fm.getHeight();
            int iconHeight = 16;
            int finalHeight = Math.max(fontHeight += 7, iconHeight);
            return finalHeight;
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        public void layoutContainer(Container c) {
            int spacing;
            int buttonWidth;
            int buttonHeight;
            int w = SubstanceDesktopIconUI.this.desktopIcon.getWidth();
            int y = 3;
            if (SubstanceDesktopIconUI.this.closeButton != null && SubstanceDesktopIconUI.this.closeButton.getIcon() != null) {
                buttonHeight = SubstanceDesktopIconUI.this.closeButton.getIcon().getIconHeight();
                buttonWidth = SubstanceDesktopIconUI.this.closeButton.getIcon().getIconWidth();
            } else {
                buttonHeight = 16;
                buttonWidth = 16;
            }
            int x = spacing = 5;
            x = w;
            spacing = 4;
            SubstanceDesktopIconUI.this.closeButton.setBounds(x -= spacing + buttonWidth, y, buttonWidth, buttonHeight);
            spacing = 6;
            SubstanceDesktopIconUI.this.maximizeButton.setBounds(x -= spacing + buttonWidth, y, buttonWidth, buttonHeight);
            spacing = 2;
            SubstanceDesktopIconUI.this.restoreButton.setBounds(x -= spacing + buttonWidth, y, buttonWidth, buttonHeight);
            SubstanceDesktopIconUI.this.iconLabel.setBounds(2, y, SubstanceDesktopIconUI.this.iconLabel.getIcon().getIconWidth(), SubstanceDesktopIconUI.this.iconLabel.getIcon().getIconHeight());
            int xs = 6 + SubstanceDesktopIconUI.this.iconLabel.getIcon().getIconWidth();
            SubstanceDesktopIconUI.this.titleLabel.setBounds(xs, y, x - xs - 5, buttonHeight);
        }
    }

    class TitleListener
    implements PropertyChangeListener {
        TitleListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("title")) {
                SubstanceDesktopIconUI.this.restoreButton.setText((String)e.getNewValue());
            }
            if (e.getPropertyName().equals("frameIcon")) {
                SubstanceDesktopIconUI.this.iconLabel.setIcon((Icon)e.getNewValue());
            }
        }
    }
}

