/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODBorders;
import com.nilo.plaf.nimrod.NimRODLookAndFeel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import javax.swing.Popup;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;

public class NimRODPopupMenuUI
extends BasicPopupMenuUI {
    private static Robot robot = null;
    private BufferedImage fondo = null;
    private MiPL mipl;

    public static ComponentUI createUI(JComponent c) {
        if (robot == null) {
            try {
                robot = new Robot();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new NimRODPopupMenuUI();
    }

    public void installDefaults() {
        super.installDefaults();
        this.popupMenu.setBorder(NimRODBorders.getPopupMenuBorder());
        this.popupMenu.setOpaque(false);
    }

    public void uninstallDefaults() {
        super.uninstallDefaults();
        LookAndFeel.installBorder(this.popupMenu, "PopupMenu.border");
        this.popupMenu.setOpaque(true);
    }

    public void installListeners() {
        super.installListeners();
        this.mipl = new MiPL(this.popupMenu);
        this.popupMenu.addPopupMenuListener(this.mipl);
    }

    public void uninstallListeners() {
        super.uninstallListeners();
        this.popupMenu.removePopupMenuListener(this.mipl);
    }

    public void update(Graphics g, JComponent c) {
        int opacidad = 220;
        try {
            opacidad = NimRODLookAndFeel.getOpacity();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Color cFondo = new Color(c.getBackground().getRed(), c.getBackground().getGreen(), c.getBackground().getBlue(), opacidad);
        if (this.fondo != null) {
            g.drawImage(this.fondo, 0, 0, null);
        }
        g.setColor(cFondo);
        g.fillRect(0, 0, c.getWidth() - 4, c.getHeight() - 4);
    }

    public Popup getPopup(JPopupMenu pop, int x, int y) {
        Dimension dim = pop.getPreferredSize();
        Rectangle rect = new Rectangle(x, y, dim.width, dim.height);
        this.fondo = robot.createScreenCapture(rect);
        return super.getPopup(pop, x, y);
    }

    private class MiPL
    implements PopupMenuListener {
        JPopupMenu papi;

        public MiPL(JPopupMenu pop) {
            this.papi = pop;
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent ev) {
            if (NimRODPopupMenuUI.this.fondo == null) {
                return;
            }
            Graphics g = this.papi.getRootPane().getGraphics();
            Point p = this.papi.getLocationOnScreen();
            Point r = this.papi.getRootPane().getLocationOnScreen();
            g.drawImage(NimRODPopupMenuUI.this.fondo, p.x - r.x, p.y - r.y, null);
            NimRODPopupMenuUI.this.fondo = null;
        }

        public void popupMenuCanceled(PopupMenuEvent ev) {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent ev) {
        }
    }
}

