/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODBorders;
import com.nilo.plaf.nimrod.NimRODLookAndFeel;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.plaf.metal.MetalButtonUI;

public class NimRODButtonUI
extends MetalButtonUI {
    protected RoundRectangle2D.Float boton;
    protected MiML miml;

    public static ComponentUI createUI(JComponent c) {
        return new NimRODButtonUI();
    }

    public void installDefaults(AbstractButton button) {
        super.installDefaults(button);
        button.setBorder(NimRODBorders.getButtonBorder());
    }

    public void unsinstallDefaults(AbstractButton button) {
        super.uninstallDefaults(button);
        button.setBorder(MetalBorders.getButtonBorder());
    }

    public void installListeners(AbstractButton b) {
        super.installListeners(b);
        this.miml = new MiML(b);
        b.addMouseListener(this.miml);
    }

    protected void uninstallListeners(AbstractButton b) {
        b.removeMouseListener(this.miml);
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        if (b.isContentAreaFilled()) {
            Graphics2D g2D = (Graphics2D)g;
            g2D.setColor(this.selectColor);
            this.hazBoton(b);
            g2D.fill(this.boton);
        }
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (b.getParent() instanceof JToolBar) {
            return;
        }
        g.setColor(this.getFocusColor());
        g.drawRoundRect(2, 2, b.getWidth() - 6, b.getHeight() - 6, 5, 5);
        g.drawRoundRect(3, 3, b.getWidth() - 6, b.getHeight() - 6, 4, 4);
    }

    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        if (!c.isOpaque()) {
            return;
        }
        Graphics2D g2D = (Graphics2D)g;
        ButtonModel mod = ((AbstractButton)c).getModel();
        if (c.getParent() instanceof JToolBar && !mod.isRollover()) {
            return;
        }
        this.hazBoton(c);
        GradientPaint grad = null;
        grad = mod.isPressed() || mod.isSelected() ? new GradientPaint(0.0f, 0.0f, NimRODLookAndFeel.sombra, 0.0f, c.getHeight(), NimRODLookAndFeel.brillo) : new GradientPaint(0.0f, 0.0f, NimRODLookAndFeel.brillo, 0.0f, c.getHeight(), NimRODLookAndFeel.sombra);
        g2D.setPaint(grad);
        g2D.fill(this.boton);
        if (mod.isRollover()) {
            g2D.setColor(NimRODLookAndFeel.getRolloverColor());
            g2D.fill(this.boton);
        }
    }

    private void hazBoton(JComponent c) {
        this.boton = new RoundRectangle2D.Float();
        this.boton.x = 0.0f;
        this.boton.y = 0.0f;
        this.boton.width = c.getWidth();
        this.boton.height = c.getHeight();
        this.boton.arcwidth = 8.0f;
        this.boton.archeight = 8.0f;
    }

    public class MiML
    extends MouseInputAdapter {
        private AbstractButton papi;

        MiML(AbstractButton b) {
            this.papi = b;
        }

        public void mouseEntered(MouseEvent e) {
            this.papi.getModel().setRollover(true);
            this.papi.repaint();
        }

        public void mouseExited(MouseEvent e) {
            this.papi.getModel().setRollover(false);
            this.papi.repaint();
        }
    }
}

