/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.smart;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseRootPaneUI;
import com.jtattoo.plaf.BaseTitlePane;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.DecorationHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.NoFocusButton;
import com.jtattoo.plaf.smart.SmartIcons;
import com.jtattoo.plaf.smart.SmartLookAndFeel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ColorUIResource;

public class SmartTitlePane
extends BaseTitlePane {
    protected static final Icon iconIcon = SmartIcons.getIconButtonIcon();
    protected static final Icon minIcon = SmartIcons.getMinButtonIcon();
    protected static final Icon maxIcon = SmartIcons.getMaxButtonIcon();
    protected static final Icon closeIcon = SmartIcons.getCloseButtonIcon();

    public SmartTitlePane(JRootPane jRootPane, BaseRootPaneUI baseRootPaneUI) {
        super(jRootPane, baseRootPaneUI);
    }

    public void createButtons() {
        this.closeButton = new TitleButton(this.closeAction, "Close");
        this.iconifyButton = new TitleButton(this.iconifyAction, "Iconify");
        this.maxButton = new TitleButton(this.restoreAction, "Maximize");
        this.setButtonIcons();
    }

    protected void setButtonIcons() {
        this.iconifyButton.setIcon(iconIcon);
        if ((this.state & 6) == 0) {
            this.maxButton.setIcon(maxIcon);
        } else {
            this.maxButton.setIcon(minIcon);
        }
        this.closeButton.setIcon(closeIcon);
    }

    protected void updateMaxButton(Action action, Icon icon) {
        this.maxButton.setAction(action);
        if ((this.state & 6) == 0) {
            this.maxButton.setIcon(minIcon);
        } else {
            this.maxButton.setIcon(maxIcon);
        }
    }

    protected void setActive(boolean bl) {
        super.setActive(bl);
        this.setButtonIcons();
    }

    public void paintBackground(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        Color color = null;
        if (this.isActive()) {
            color = SmartLookAndFeel.getTheme().getFrameColor();
            JTattooUtilities.fillHorGradient(graphics, SmartLookAndFeel.getTheme().getWindowTitleColors(), 0, 0, n, n2);
        } else {
            color = ColorHelper.brighter(SmartLookAndFeel.getTheme().getFrameColor(), 40.0);
            JTattooUtilities.fillHorGradient(graphics, SmartLookAndFeel.getTheme().getWindowInactiveTitleColors(), 0, 0, n, n2);
        }
        graphics.setColor(color);
        graphics.drawLine(0, n2 - 1, n, n2 - 1);
    }

    public void paintComponent(Graphics graphics) {
        int n;
        int n2;
        String string;
        int n3;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.getFrame() != null) {
            this.setState(DecorationHelper.getExtendedState(this.getFrame()));
        }
        this.paintBackground(graphics);
        boolean bl = this.window == null ? this.getRootPane().getComponentOrientation().isLeftToRight() : this.window.getComponentOrientation().isLeftToRight();
        boolean bl2 = this.window == null ? true : JTattooUtilities.isWindowActive(this.window);
        int n4 = this.getWidth();
        int n5 = this.getHeight();
        ColorUIResource colorUIResource = AbstractLookAndFeel.getWindowInactiveTitleForegroundColor();
        Color color = SmartLookAndFeel.getTheme().getWindowInactiveTitleColors()[10];
        if (bl2) {
            colorUIResource = AbstractLookAndFeel.getWindowTitleForegroundColor();
            color = SmartLookAndFeel.getTheme().getWindowTitleColors()[10];
        }
        int n6 = this.iconifyButton.getWidth();
        int n7 = n3 = bl ? 5 : n4 - 5;
        if (this.getWindowDecorationStyle() == 1) {
            n3 += bl ? n6 + 5 : -n6 - 5;
        }
        if ((string = this.getTitle()) != null) {
            int n8;
            FontMetrics fontMetrics = graphics.getFontMetrics();
            graphics.setColor(colorUIResource);
            n2 = (n5 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent();
            Rectangle rectangle = this.iconifyButton.getBounds();
            if (bl) {
                if (rectangle.x == 0) {
                    rectangle.x = this.window.getWidth() - this.window.getInsets().right - 2;
                }
                n8 = rectangle.x - n3 - 4;
                string = JTattooUtilities.getClippedText(string, fontMetrics, n8);
            } else {
                n8 = n3 - rectangle.x - rectangle.width - 4;
                string = JTattooUtilities.getClippedText(string, fontMetrics, n8);
                n3 -= SwingUtilities.computeStringWidth(fontMetrics, string);
            }
            int n9 = SwingUtilities.computeStringWidth(fontMetrics, string);
            if (ColorHelper.getGrayValue(colorUIResource) > 164) {
                graphics.setColor(Color.black);
                JTattooUtilities.drawString(this.rootPane, graphics, string, n3 + 1, n2 + 1);
            }
            graphics.setColor(colorUIResource);
            JTattooUtilities.drawString(this.rootPane, graphics, string, n3, n2);
            n3 += bl ? n9 + 5 : -5;
        }
        if (bl) {
            n2 = n4 - this.buttonsWidth - n3 - 10;
            n = n3;
        } else {
            n2 = n3 - this.buttonsWidth - 10;
            n = this.buttonsWidth + 10;
        }
        int n10 = 3;
        if (n2 > 0) {
            Composite composite = graphics2D.getComposite();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.6f);
            graphics2D.setComposite(alphaComposite);
            float f = 50.0f;
            float f2 = 5.0f;
            Color color2 = ColorHelper.brighter(color, f);
            Color color3 = null;
            while (n10 + 5 < n5) {
                color3 = ColorHelper.darker(color, f2);
                f2 += 5.0f;
                graphics.setColor(color2);
                graphics.drawLine(n, n10, n + n2, n10);
                graphics.setColor(color3);
                graphics.drawLine(n, ++n10, n + n2, n10);
                n10 += 3;
            }
            graphics2D.setComposite(composite);
        }
    }

    private class TitleButton
    extends NoFocusButton {
        public TitleButton(Action action, String string) {
            this.setContentAreaFilled(false);
            this.setBorderPainted(false);
            this.setAction(action);
            this.setText(null);
            this.putClientProperty("paintActive", Boolean.TRUE);
            this.getAccessibleContext().setAccessibleName(string);
        }

        public void paint(Graphics graphics) {
            if (JTattooUtilities.isWindowActive(SmartTitlePane.this.window)) {
                super.paint(graphics);
            } else {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Composite composite = graphics2D.getComposite();
                AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.6f);
                graphics2D.setComposite(alphaComposite);
                super.paint(graphics);
                graphics2D.setComposite(composite);
            }
        }
    }
}

