/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.mint;

import com.jtattoo.plaf.BaseComboBoxUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.mint.MintIcons;
import com.jtattoo.plaf.mint.MintLookAndFeel;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.ComponentUI;

public class MintComboBoxUI
extends BaseComboBoxUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new MintComboBoxUI();
    }

    public JButton createArrowButton() {
        ArrowButton arrowButton = new ArrowButton();
        if (JTattooUtilities.isLeftToRight(this.comboBox)) {
            MatteBorder matteBorder = BorderFactory.createMatteBorder(0, 1, 0, 0, MintLookAndFeel.getFrameColor());
            arrowButton.setBorder(matteBorder);
        } else {
            MatteBorder matteBorder = BorderFactory.createMatteBorder(0, 0, 0, 1, MintLookAndFeel.getFrameColor());
            arrowButton.setBorder(matteBorder);
        }
        return arrowButton;
    }

    static class ArrowButton
    extends JButton {
        public ArrowButton() {
            super(MintIcons.getComboBoxIcon());
            this.setContentAreaFilled(false);
        }

        public void paint(Graphics graphics) {
            Color color = MintLookAndFeel.getTheme().getButtonBackgroundColor();
            int n = this.getWidth();
            int n2 = this.getHeight();
            ButtonModel buttonModel = this.getModel();
            if (buttonModel.isEnabled()) {
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    color = MintLookAndFeel.getTheme().getSelectionBackgroundColor();
                } else if (buttonModel.isRollover()) {
                    color = MintLookAndFeel.getTheme().getRolloverColors()[10];
                }
            }
            graphics.setColor(color);
            graphics.fillRect(0, 0, n, n2);
            if (JTattooUtilities.isLeftToRight(this)) {
                JTattooUtilities.draw3DBorder(graphics, ColorHelper.brighter(color, 60.0), ColorHelper.darker(color, 15.0), 1, 0, n - 1, n2);
            } else {
                JTattooUtilities.draw3DBorder(graphics, ColorHelper.brighter(color, 60.0), ColorHelper.darker(color, 15.0), 0, 0, n - 1, n2);
            }
            Icon icon = this.getIcon();
            int n3 = (n - icon.getIconWidth()) / 2;
            int n4 = (n2 - icon.getIconHeight()) / 2;
            icon.paintIcon(this, graphics, n3, n4);
            this.paintBorder(graphics);
        }
    }
}

