/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.bernstein;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseCheckBoxMenuItemUI;
import com.jtattoo.plaf.bernstein.BernsteinLookAndFeel;
import com.jtattoo.plaf.bernstein.BernsteinUtils;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.plaf.ComponentUI;

public class BernsteinCheckBoxMenuItemUI
extends BaseCheckBoxMenuItemUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new BernsteinCheckBoxMenuItemUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setOpaque(false);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        jComponent.setOpaque(true);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        this.paintBackground(graphics, jComponent, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(graphics, jComponent);
    }

    protected void paintBackground(Graphics graphics, JComponent jComponent, int n, int n2, int n3, int n4) {
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        ButtonModel buttonModel = jMenuItem.getModel();
        if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
            graphics.setColor(BernsteinLookAndFeel.getMenuSelectionBackgroundColor());
            graphics.fillRect(n, n2, n3, n4);
        } else if (!BernsteinLookAndFeel.getTheme().isMenuOpaque()) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, BernsteinLookAndFeel.getTheme().getMenuAlpha());
            graphics2D.setComposite(alphaComposite);
            BernsteinUtils.fillComponent(graphics, jComponent);
            graphics2D.setComposite(composite);
        } else {
            BernsteinUtils.fillComponent(graphics, jComponent);
        }
        graphics.setColor(AbstractLookAndFeel.getMenuForegroundColor());
    }
}

