/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.aluminium;

import com.jtattoo.plaf.BaseTheme;
import com.jtattoo.plaf.ColorHelper;
import java.awt.Color;
import javax.swing.plaf.ColorUIResource;

public class AluminiumDefaultTheme
extends BaseTheme {
    public AluminiumDefaultTheme() {
        AluminiumDefaultTheme.setUp();
        this.loadProperties();
        AluminiumDefaultTheme.setupColorArrs();
    }

    public static void setUp() {
        BaseTheme.setUp();
        backgroundColor = new ColorUIResource(200, 200, 200);
        frameColor = new ColorUIResource(140, 140, 140);
        backgroundPattern = true;
        selectionForegroundColor = black;
        selectionBackgroundColor = new ColorUIResource(224, 227, 206);
        focusCellColor = focusColor = new ColorUIResource(255, 128, 96);
        rolloverColor = new ColorUIResource(214, 219, 191);
        rolloverColorLight = new ColorUIResource(220, 224, 201);
        rolloverColorDark = new ColorUIResource(196, 203, 163);
        buttonBackgroundColor = extraLightGray;
        buttonColorLight = white;
        buttonColorDark = new ColorUIResource(210, 212, 214);
        controlBackgroundColor = extraLightGray;
        controlColorLight = new ColorUIResource(244, 244, 244);
        controlColorDark = new ColorUIResource(224, 224, 224);
        controlHighlightColor = new ColorUIResource(240, 240, 240);
        controlShadowColor = new ColorUIResource(180, 180, 180);
        windowTitleForegroundColor = new ColorUIResource(32, 32, 32);
        windowTitleBackgroundColor = new ColorUIResource(200, 200, 200);
        windowTitleColorLight = new ColorUIResource(200, 200, 200);
        windowTitleColorDark = new ColorUIResource(160, 160, 160);
        windowBorderColor = new ColorUIResource(120, 120, 120);
        windowInactiveTitleForegroundColor = black;
        windowInactiveTitleBackgroundColor = new ColorUIResource(220, 220, 220);
        windowInactiveTitleColorLight = new ColorUIResource(220, 220, 220);
        windowInactiveTitleColorDark = new ColorUIResource(200, 200, 200);
        windowInactiveBorderColor = new ColorUIResource(140, 140, 140);
        menuBackgroundColor = extraLightGray;
        menuSelectionForegroundColor = selectionForegroundColor;
        menuSelectionBackgroundColor = new ColorUIResource(202, 208, 172);
        menuColorLight = controlColorLight;
        menuColorDark = controlColorDark;
        toolbarBackgroundColor = backgroundColor;
        toolbarColorLight = new ColorUIResource(240, 240, 240);
        toolbarColorDark = new ColorUIResource(200, 200, 200);
        desktopColor = backgroundColor;
    }

    public static void setupColorArrs() {
        int n;
        BaseTheme.setupColorArrs();
        DEFAULT_COLORS = ColorHelper.createColorArr(controlColorLight, controlColorDark, 20);
        HIDEFAULT_COLORS = new Color[DEFAULT_COLORS.length];
        for (n = 0; n < DEFAULT_COLORS.length; ++n) {
            AluminiumDefaultTheme.HIDEFAULT_COLORS[n] = ColorHelper.brighter(DEFAULT_COLORS[n], 20.0);
        }
        ACTIVE_COLORS = DEFAULT_COLORS;
        INACTIVE_COLORS = ColorHelper.createColorArr(new Color(220, 220, 220), new Color(200, 200, 200), 20);
        PRESSED_COLORS = new Color[DEFAULT_COLORS.length];
        for (n = 0; n < DEFAULT_COLORS.length; ++n) {
            AluminiumDefaultTheme.PRESSED_COLORS[n] = ColorHelper.brighter(DEFAULT_COLORS[n], 30.0);
        }
        DISABLED_COLORS = ColorHelper.createColorArr(Color.white, Color.lightGray, 20);
        BUTTON_COLORS = new Color[]{new Color(240, 240, 240), new Color(235, 235, 235), new Color(232, 232, 232), new Color(230, 230, 230), new Color(228, 228, 228), new Color(225, 225, 225), new Color(220, 220, 220), new Color(215, 215, 215), new Color(210, 210, 210), new Color(205, 205, 205), new Color(210, 210, 210), new Color(215, 215, 215), new Color(220, 220, 220), new Color(225, 225, 225), new Color(228, 228, 228), new Color(230, 230, 230), new Color(232, 232, 232), new Color(235, 235, 235)};
        ROLLOVER_COLORS = ColorHelper.createColorArr(rolloverColorLight, rolloverColorDark, 20);
        WINDOW_TITLE_COLORS = ColorHelper.createColorArr(windowTitleColorLight, windowTitleColorDark, 20);
        WINDOW_INACTIVE_TITLE_COLORS = ColorHelper.createColorArr(windowInactiveTitleColorLight, windowInactiveTitleColorDark, 20);
        MENUBAR_COLORS = ColorHelper.createColorArr(menuColorLight, menuColorDark, 20);
        TOOLBAR_COLORS = ColorHelper.createColorArr(toolbarColorLight, toolbarColorDark, 20);
        TAB_COLORS = DEFAULT_COLORS;
        COL_HEADER_COLORS = BUTTON_COLORS;
        SELECTED_COLORS = DEFAULT_COLORS;
        TRACK_COLORS = ColorHelper.createColorArr(new Color(210, 210, 210), new Color(230, 230, 230), 20);
        THUMB_COLORS = ColorHelper.createColorArr(new Color(200, 200, 200), new Color(170, 170, 170), 20);
        SLIDER_COLORS = ColorHelper.createColorArr(new Color(180, 180, 180), new Color(150, 150, 150), 10);
        PROGRESSBAR_COLORS = SLIDER_COLORS;
    }

    public String getName() {
        return AluminiumDefaultTheme.getInternalName();
    }

    public static String getInternalName() {
        return "AluminiumTheme";
    }
}

