/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.acryl;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseBorders;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.acryl.AcrylLookAndFeel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class AcrylBorders
extends BaseBorders {
    private static Border textFieldBorder = null;
    private static Border spinnerBorder = null;
    private static Border comboBoxBorder = null;
    private static Border buttonBorder = null;
    private static Border toggleButtonBorder = null;
    private static Border toolButtonBorder = null;
    private static Border rolloverToolButtonBorder = null;
    private static Border popupMenuBorder = null;
    private static Border internalFrameBorder = null;

    public static Border getTextBorder() {
        if (textFieldBorder == null) {
            textFieldBorder = new TextFieldBorder();
        }
        return textFieldBorder;
    }

    public static Border getSpinnerBorder() {
        if (spinnerBorder == null) {
            spinnerBorder = new SpinnerBorder();
        }
        return spinnerBorder;
    }

    public static Border getTextFieldBorder() {
        return AcrylBorders.getTextBorder();
    }

    public static Border getComboBoxBorder() {
        if (comboBoxBorder == null) {
            comboBoxBorder = new ComboBoxBorder();
        }
        return comboBoxBorder;
    }

    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new ButtonBorder();
        }
        return buttonBorder;
    }

    public static Border getToggleButtonBorder() {
        if (toggleButtonBorder == null) {
            toggleButtonBorder = new ToggleButtonBorder();
        }
        return toggleButtonBorder;
    }

    public static Border getToolButtonBorder() {
        if (toolButtonBorder == null) {
            toolButtonBorder = new ToolButtonBorder();
        }
        return toolButtonBorder;
    }

    public static Border getRolloverToolButtonBorder() {
        if (rolloverToolButtonBorder == null) {
            rolloverToolButtonBorder = new RolloverToolButtonBorder();
        }
        return rolloverToolButtonBorder;
    }

    public static Border getPopupMenuBorder() {
        if (popupMenuBorder == null) {
            popupMenuBorder = new PopupMenuBorder();
        }
        return popupMenuBorder;
    }

    public static Border getInternalFrameBorder() {
        if (internalFrameBorder == null) {
            internalFrameBorder = new InternalFrameBorder();
        }
        return internalFrameBorder;
    }

    public static class InternalFrameBorder
    extends BaseBorders.BaseInternalFrameBorder {
        public InternalFrameBorder() {
            this.insets.top = 3;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            boolean bl = this.isActive(component);
            int n5 = this.getTitleHeight(component);
            Color color = AcrylLookAndFeel.getWindowInactiveTitleBackgroundColor();
            ColorUIResource colorUIResource = AcrylLookAndFeel.getWindowInactiveTitleColorDark();
            Color color2 = ColorHelper.darker(AcrylLookAndFeel.getWindowInactiveBorderColor(), 10.0);
            if (bl) {
                color = ColorHelper.brighter(AcrylLookAndFeel.getWindowTitleColorLight(), 20.0);
                colorUIResource = AcrylLookAndFeel.getWindowTitleColorLight();
                color2 = ColorHelper.darker(AcrylLookAndFeel.getWindowBorderColor(), 10.0);
            }
            graphics.setColor(color);
            graphics.fillRect(n, n2 + 1, n3, this.insets.top - 1);
            graphics.setColor(colorUIResource);
            graphics.fillRect(n + 1, n2 + n4 - 5, n3 - 2, 4);
            if (bl) {
                JTattooUtilities.fillHorGradient(graphics, AcrylLookAndFeel.getTheme().getWindowTitleColors(), 1, this.insets.top, 5, n5 + 1);
                JTattooUtilities.fillHorGradient(graphics, AcrylLookAndFeel.getTheme().getWindowTitleColors(), n3 - 5, this.insets.top, 5, n5 + 1);
            } else {
                JTattooUtilities.fillHorGradient(graphics, AcrylLookAndFeel.getTheme().getWindowInactiveTitleColors(), 1, this.insets.top, 4, n5 + 1);
                JTattooUtilities.fillHorGradient(graphics, AcrylLookAndFeel.getTheme().getWindowInactiveTitleColors(), n3 - 5, this.insets.top, 4, n5 + 1);
            }
            graphics.setColor(colorUIResource);
            graphics.fillRect(1, this.insets.top + n5 + 1, 4, n4 - n5 - 5);
            graphics.fillRect(n3 - 5, this.insets.top + n5 + 1, 4, n4 - n5 - 5);
            graphics.setColor(color2);
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
            graphics.drawLine(n + 5 - 1, n2 + this.insets.top + n5, n + 5 - 1, n2 + n4 - 5);
            graphics.drawLine(n + n3 - 5, n2 + this.insets.top + n5, n + n3 - 5, n2 + n4 - 5);
            graphics.drawLine(n + 5 - 1, n2 + n4 - 5, n + n3 - 5, n2 + n4 - 5);
        }
    }

    public static class PopupMenuBorder
    extends AbstractBorder
    implements UIResource {
        private static final Font logoFont = new Font("Dialog", 1, 12);
        private static final int shadowSize = 4;
        private static final Insets logoInsets = new Insets(2, 18, 5, 5);
        private static final Insets insets = new Insets(2, 1, 5, 5);

        public boolean hasLogo() {
            return AbstractLookAndFeel.getTheme().getLogoString() != null && AbstractLookAndFeel.getTheme().getLogoString().length() > 0;
        }

        public void paintLogo(Graphics2D graphics2D, int n, int n2) {
            BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
            Graphics2D graphics2D2 = bufferedImage.createGraphics();
            Color color = ColorHelper.darker(AbstractLookAndFeel.getTheme().getMenuSelectionBackgroundColor(), 20.0);
            graphics2D2.setColor(color);
            graphics2D2.fillRect(0, 0, n, n2);
            graphics2D2.setFont(logoFont);
            FontMetrics fontMetrics = graphics2D2.getFontMetrics();
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.setToRotation(4.71238898038469);
            graphics2D2.setTransform(affineTransform);
            int n3 = -n2 + 4;
            int n4 = fontMetrics.getAscent() + 2;
            graphics2D2.setColor(ColorHelper.darker(color, 40.0));
            graphics2D2.drawString(JTattooUtilities.getClippedText(AbstractLookAndFeel.getTheme().getLogoString(), fontMetrics, n2 - 16), n3 - 1, n4 + 1);
            graphics2D2.setColor(Color.white);
            graphics2D2.drawString(JTattooUtilities.getClippedText(AbstractLookAndFeel.getTheme().getLogoString(), fontMetrics, n2 - 16), n3, n4);
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, n, n2);
            TexturePaint texturePaint = new TexturePaint(bufferedImage, double_);
            graphics2D.setPaint(texturePaint);
            graphics2D.fillRect(0, 0, n, n2);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            AlphaComposite alphaComposite = null;
            Composite composite = graphics2D.getComposite();
            if (!AcrylLookAndFeel.getTheme().isMenuOpaque()) {
                alphaComposite = AlphaComposite.getInstance(3, 0.6f);
                graphics2D.setComposite(alphaComposite);
            }
            int n5 = this.getBorderInsets((Component)component).left;
            ColorUIResource colorUIResource = AbstractLookAndFeel.getTheme().getMenuSelectionBackgroundColor();
            graphics.setColor(colorUIResource);
            graphics.fillRect(n, n2, n5 - 1, n4 - 1 - 4);
            if (this.hasLogo()) {
                this.paintLogo(graphics2D, n5, n4 - 4);
            }
            graphics.setColor(ColorHelper.brighter(colorUIResource, 50.0));
            graphics.drawLine(n + 1, n2 + 1, n + n5, n2 + 1);
            graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + n4 - 4 - 1);
            graphics.setColor(Color.white);
            graphics.drawLine(n + n5, n2 + 1, n + n3 - 2, n2 + 1);
            graphics.setColor(ColorHelper.darker(colorUIResource, 30.0));
            graphics.drawLine(n + n5 - 1, n2 + 1, n + n5 - 1, n2 + n4 - 4 - 1);
            graphics.setColor(AbstractLookAndFeel.getFrameColor());
            graphics.drawRect(n, n2, n3 - 4 - 1, n4 - 4 - 1);
            graphics2D.setColor(Color.black);
            float f = 0.6f;
            for (int i = 0; i < 4; ++i) {
                alphaComposite = AlphaComposite.getInstance(3, f);
                graphics2D.setComposite(alphaComposite);
                graphics.drawLine(n + n3 - 4 + i, n2 + 4, n + n3 - 4 + i, n2 + n4 - 4 - 1 + i);
                graphics.drawLine(n + 4, n2 + n4 - 4 + i, n + n3 - 4 + i, n2 + n4 - 4 + i);
                f -= f / 2.0f;
            }
            graphics2D.setComposite(composite);
        }

        public Insets getBorderInsets(Component component) {
            if (this.hasLogo()) {
                return logoInsets;
            }
            return insets;
        }
    }

    public static class RolloverToolButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(2, 3, 2, 3);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (buttonModel.isEnabled()) {
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    ColorUIResource colorUIResource = AbstractLookAndFeel.getToolbarBackgroundColor();
                    Color color = ColorHelper.brighter(colorUIResource, 80.0);
                    Color color2 = ColorHelper.darker(colorUIResource, 20.0);
                    JTattooUtilities.draw3DBorder(graphics, color2, color, n, n2, n3, n4);
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    Composite composite = graphics2D.getComposite();
                    AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.1f);
                    graphics2D.setComposite(alphaComposite);
                    graphics.setColor(Color.black);
                    graphics.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
                    graphics2D.setComposite(composite);
                } else if (buttonModel.isRollover()) {
                    ColorUIResource colorUIResource = AbstractLookAndFeel.getToolbarBackgroundColor();
                    Color color = ColorHelper.darker(colorUIResource, 5.0);
                    Color color3 = ColorHelper.darker(colorUIResource, 30.0);
                    JTattooUtilities.draw3DBorder(graphics, color, color3, n, n2, n3, n4);
                    color = Color.white;
                    color3 = ColorHelper.brighter(color3, 60.0);
                    JTattooUtilities.draw3DBorder(graphics, color, color3, n + 1, n2 + 1, n3 - 2, n4 - 2);
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    Composite composite = graphics2D.getComposite();
                    AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.4f);
                    graphics2D.setComposite(alphaComposite);
                    graphics.setColor(Color.white);
                    graphics.fillRect(n + 2, n2 + 2, n3 - 4, n4 - 4);
                    graphics2D.setComposite(composite);
                } else if (buttonModel.isSelected()) {
                    ColorUIResource colorUIResource = AbstractLookAndFeel.getToolbarBackgroundColor();
                    Color color = Color.white;
                    Color color4 = ColorHelper.darker(colorUIResource, 30.0);
                    JTattooUtilities.draw3DBorder(graphics, color4, color, n, n2, n3, n4);
                }
            }
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ToolButtonBorder
    implements Border,
    UIResource {
        private static final Color frameHiColor = Color.white;
        private static final Color frameLoColor = Color.gray;
        private static final Insets insets = new Insets(2, 3, 2, 3);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (buttonModel.isEnabled()) {
                if (buttonModel.isPressed() && buttonModel.isArmed() || buttonModel.isSelected()) {
                    JTattooUtilities.draw3DBorder(graphics, frameLoColor, frameHiColor, n, n2, n3, n4);
                } else {
                    JTattooUtilities.draw3DBorder(graphics, frameHiColor, frameLoColor, n, n2, n3, n4);
                }
            }
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ToggleButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(3, 8, 3, 8);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (buttonModel.isEnabled()) {
                Color color = Color.white;
                Color color2 = ColorHelper.brighter(AcrylLookAndFeel.getFrameColor(), 80.0);
                Color color3 = ColorHelper.brighter(AcrylLookAndFeel.getFrameColor(), 65.0);
                Color color4 = ColorHelper.brighter(AcrylLookAndFeel.getFrameColor(), 20.0);
                if (buttonModel.isPressed() && buttonModel.isArmed() || buttonModel.isSelected()) {
                    JTattooUtilities.draw3DBorder(graphics, color4, color3, n + 1, n2 + 1, n3 - 2, n4 - 2);
                    JTattooUtilities.draw3DBorder(graphics, color3, color, n + 2, n2 + 2, n3 - 4, n4 - 4);
                } else {
                    JTattooUtilities.draw3DBorder(graphics, color2, color, n, n2, n3, n4);
                    JTattooUtilities.draw3DBorder(graphics, ColorHelper.brighter(AcrylLookAndFeel.getFrameColor(), 20.0), AcrylLookAndFeel.getFrameColor(), n + 1, n2 + 1, n3 - 2, n4 - 2);
                }
            } else {
                JTattooUtilities.drawBorder(graphics, Color.lightGray, n, n2, n3, n4);
            }
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ButtonBorder
    implements Border,
    UIResource {
        private static final Insets borderInsets = new Insets(3, 8, 3, 8);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JButton jButton = (JButton)component;
            ButtonModel buttonModel = jButton.getModel();
            --n3;
            --n4;
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color color = AbstractLookAndFeel.getTheme().getFrameColor();
            if (!JTattooUtilities.isFrameActive(jButton)) {
                color = ColorHelper.brighter(color, 60.0);
            }
            if (buttonModel.isRollover() && !buttonModel.isPressed() && !buttonModel.isArmed()) {
                color = AbstractLookAndFeel.getTheme().getRolloverColor();
            }
            Color color2 = component.getParent().getBackground();
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(ColorHelper.darker(color2, 10.0));
            graphics2D.drawLine(n, n2 + 2, n + 2, n2);
            graphics2D.drawLine(n + 2, n2, n3 - 2, n2);
            graphics2D.drawLine(n3 - 2, n2, n3, n2 + 2);
            graphics2D.setColor(ColorHelper.darker(color2, 5.0));
            graphics2D.drawLine(n, n2 + 2, n, n4 - 2);
            graphics2D.drawLine(n3, n2 + 2, n3, n4 - 2);
            graphics2D.setColor(ColorHelper.brighter(color2, 20.0));
            graphics2D.drawLine(n, n4 - 2, n + 2, n4);
            graphics2D.drawLine(n3, n4 - 2, n3 - 2, n4);
            graphics2D.setColor(ColorHelper.brighter(color2, 60.0));
            graphics2D.drawLine(n + 2, n4, n3 - 2, n4);
            if (!buttonModel.isPressed() && !buttonModel.isArmed() && jButton.isDefaultCapable() && jButton.isDefaultButton() && JTattooUtilities.isFrameActive(jButton)) {
                graphics.setColor(AbstractLookAndFeel.getTheme().getControlColorLight());
                graphics2D.drawLine(n + 2, n2 + 3, n + 2, n4 - 2);
                graphics2D.drawLine(n3 - 2, n2 + 3, n3 - 2, n4 - 2);
                graphics2D.drawLine(n + 3, n2 + 2, n + 3, n4 - 1);
                graphics2D.drawLine(n3 - 3, n2 + 2, n3 - 3, n4 - 1);
            }
            graphics2D.setColor(color);
            graphics2D.drawLine(++n, ++n2 + 2, n + 2, n2);
            graphics2D.drawLine(n + 2, n2, --n3 - 2, n2);
            graphics2D.drawLine(n3 - 2, n2, n3, n2 + 2);
            graphics2D.drawLine(n, n2 + 2, n, --n4 - 2);
            graphics2D.drawLine(n3, n2 + 2, n3, n4 - 2);
            graphics2D.drawLine(n, n4 - 2, n + 2, n4);
            graphics2D.drawLine(n3, n4 - 2, n3 - 2, n4);
            graphics2D.drawLine(n + 2, n4, n3 - 2, n4);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
            graphics.setColor(AbstractLookAndFeel.getBackgroundColor());
            graphics.drawLine(0, n4, 1, n4 + 1);
            graphics.drawLine(n3, n4, n3 + 1, n4 + 1);
            graphics.drawLine(n3, n4 + 1, n3 + 1, n4 + 1);
        }

        public Insets getBorderInsets(Component component) {
            return borderInsets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ComboBoxBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getFrameColor(), 50.0);
            graphics.setColor(color);
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }
    }

    public static class SpinnerBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getFrameColor(), 50.0);
            graphics.setColor(color);
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }
    }

    public static class TextFieldBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(2, 2, 2, 2);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getFrameColor(), 50.0);
            graphics.setColor(color);
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }
    }
}

