/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseIcons;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;

public class BaseComboBoxUI
extends BasicComboBoxUI {
    protected PropertyChangeListener propertyChangeListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BaseComboBoxUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.comboBox.setRequestFocusEnabled(true);
        if (this.comboBox.getEditor() != null && this.comboBox.getEditor().getEditorComponent() instanceof JTextField) {
            ((JTextField)this.comboBox.getEditor().getEditorComponent()).setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        }
    }

    protected void installListeners() {
        super.installListeners();
        this.propertyChangeListener = new PropertyChangeHandler();
        this.comboBox.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void uninstallListeners() {
        this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        super.uninstallListeners();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        return new Dimension(dimension.width + 2, dimension.height + 2);
    }

    public JButton createArrowButton() {
        JButton jButton = new JButton(BaseIcons.getComboBoxIcon());
        if (JTattooUtilities.isLeftToRight(this.comboBox)) {
            MatteBorder matteBorder = BorderFactory.createMatteBorder(0, 1, 0, 0, AbstractLookAndFeel.getFrameColor());
            jButton.setBorder(matteBorder);
        } else {
            MatteBorder matteBorder = BorderFactory.createMatteBorder(0, 0, 0, 1, AbstractLookAndFeel.getFrameColor());
            jButton.setBorder(matteBorder);
        }
        return jButton;
    }

    protected void setButtonBorder() {
        if (JTattooUtilities.isLeftToRight(this.comboBox)) {
            MatteBorder matteBorder = BorderFactory.createMatteBorder(0, 1, 0, 0, AbstractLookAndFeel.getFrameColor());
            this.arrowButton.setBorder(matteBorder);
        } else {
            MatteBorder matteBorder = BorderFactory.createMatteBorder(0, 0, 0, 1, AbstractLookAndFeel.getFrameColor());
            this.arrowButton.setBorder(matteBorder);
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("componentOrientation")) {
                BaseComboBoxUI.this.setButtonBorder();
            }
        }
    }
}

