/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.mcwin;

import com.jtattoo.plaf.BaseInternalFrameTitlePane;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.NoFocusButton;
import com.jtattoo.plaf.mcwin.McWinLookAndFeel;
import com.jtattoo.plaf.mcwin.McWinUtils;
import com.jtattoo.plaf.mcwin.icons.ImageHelper;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;

public class McWinInternalFrameTitlePane
extends BaseInternalFrameTitlePane {
    protected static ImageIcon iconRolloverIcon = ImageHelper.loadImage("iconizer.gif");
    protected static ImageIcon minRolloverIcon = ImageHelper.loadImage("minimizer.gif");
    protected static ImageIcon maxRolloverIcon = ImageHelper.loadImage("maximizer.gif");
    protected static ImageIcon closeRolloverIcon = ImageHelper.loadImage("closer.gif");
    protected static ImageIcon inactiveIcon = ImageHelper.loadImage("pearl_white.gif");
    protected static ImageIcon iconInactiveRolloverIcon = ImageHelper.loadImage("iconizer_inactive.gif");
    protected static ImageIcon minInactiveRolloverIcon = ImageHelper.loadImage("minimizer_inactive.gif");
    protected static ImageIcon maxInactiveRolloverIcon = ImageHelper.loadImage("maximizer_inactive.gif");
    protected static ImageIcon closeInactiveRolloverIcon = ImageHelper.loadImage("closer_inactive.gif");

    public McWinInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    protected void createButtons() {
        this.iconIcon = ImageHelper.loadImage("pearl_green.gif");
        this.minIcon = ImageHelper.loadImage("pearl_orange.gif");
        this.maxIcon = ImageHelper.loadImage("pearl_orange.gif");
        this.closeIcon = ImageHelper.loadImage("pearl_red.gif");
        this.iconButton = new TitleButton();
        this.iconButton.setContentAreaFilled(false);
        this.iconButton.setBorderPainted(false);
        this.iconButton.addActionListener(this.iconifyAction);
        this.iconButton.addActionListener(this);
        this.maxButton = new TitleButton();
        this.maxButton.setContentAreaFilled(false);
        this.maxButton.setBorderPainted(false);
        this.maxButton.addActionListener(this.maximizeAction);
        this.maxButton.addActionListener(this);
        this.closeButton = new TitleButton();
        this.closeButton.setContentAreaFilled(false);
        this.closeButton.setBorderPainted(false);
        this.closeButton.addActionListener(this.closeAction);
        this.closeButton.addActionListener(this);
        this.setButtonIcons();
    }

    protected void setButtonIcons() {
        if (!this.frame.isSelected()) {
            this.iconButton.setIcon(inactiveIcon);
            this.maxButton.setIcon(inactiveIcon);
            if (this.frame.isIcon()) {
                this.iconButton.setRolloverIcon(minInactiveRolloverIcon);
                this.iconButton.setPressedIcon(minInactiveRolloverIcon);
                this.maxButton.setRolloverIcon(maxInactiveRolloverIcon);
                this.maxButton.setRolloverIcon(maxInactiveRolloverIcon);
            } else if (this.frame.isMaximum()) {
                this.iconButton.setRolloverIcon(iconInactiveRolloverIcon);
                this.iconButton.setPressedIcon(iconInactiveRolloverIcon);
                this.maxButton.setRolloverIcon(minInactiveRolloverIcon);
                this.maxButton.setPressedIcon(minInactiveRolloverIcon);
            } else {
                this.iconButton.setRolloverIcon(iconInactiveRolloverIcon);
                this.iconButton.setPressedIcon(iconInactiveRolloverIcon);
                this.maxButton.setRolloverIcon(maxInactiveRolloverIcon);
                this.maxButton.setPressedIcon(maxInactiveRolloverIcon);
            }
            this.closeButton.setIcon(inactiveIcon);
            this.closeButton.setRolloverIcon(closeInactiveRolloverIcon);
            this.closeButton.setPressedIcon(closeInactiveRolloverIcon);
        } else {
            if (this.frame.isIcon()) {
                this.iconButton.setIcon(this.minIcon);
                this.iconButton.setRolloverIcon(minRolloverIcon);
                this.iconButton.setPressedIcon(minRolloverIcon);
                this.maxButton.setIcon(this.maxIcon);
                this.maxButton.setRolloverIcon(maxRolloverIcon);
                this.maxButton.setPressedIcon(maxRolloverIcon);
            } else if (this.frame.isMaximum()) {
                this.iconButton.setIcon(this.iconIcon);
                this.iconButton.setRolloverIcon(iconRolloverIcon);
                this.iconButton.setPressedIcon(iconRolloverIcon);
                this.maxButton.setIcon(this.maxIcon);
                this.maxButton.setRolloverIcon(minRolloverIcon);
                this.maxButton.setPressedIcon(minRolloverIcon);
            } else {
                this.iconButton.setIcon(this.iconIcon);
                this.iconButton.setRolloverIcon(iconRolloverIcon);
                this.iconButton.setPressedIcon(iconRolloverIcon);
                this.maxButton.setIcon(this.maxIcon);
                this.maxButton.setRolloverIcon(maxRolloverIcon);
                this.maxButton.setPressedIcon(maxRolloverIcon);
            }
            this.closeButton.setIcon(this.closeIcon);
            this.closeButton.setRolloverIcon(closeRolloverIcon);
            this.closeButton.setPressedIcon(closeRolloverIcon);
        }
    }

    public void activateFrame() {
        this.setButtonIcons();
    }

    public void deactivateFrame() {
        this.setButtonIcons();
    }

    public void paintPalette(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (JTattooUtilities.isFrameActive(this)) {
            McWinUtils.fillComponent(graphics, this, McWinLookAndFeel.getTheme().getWindowTitleColors());
            graphics.setColor(McWinLookAndFeel.getWindowBorderColor());
        } else {
            McWinUtils.fillComponent(graphics, this, McWinLookAndFeel.getTheme().getWindowInactiveTitleColors());
            graphics.setColor(McWinLookAndFeel.getWindowInactiveBorderColor());
        }
        graphics.drawLine(0, n2 - 1, n, n2 - 1);
    }

    public void paintBackground(Graphics graphics) {
        if (JTattooUtilities.isActive(this)) {
            McWinUtils.fillComponent(graphics, this, McWinLookAndFeel.getTheme().getWindowTitleColors());
        } else {
            McWinUtils.fillComponent(graphics, this, McWinLookAndFeel.getTheme().getWindowInactiveTitleColors());
        }
    }

    public void paintBorder(Graphics graphics) {
        if (JTattooUtilities.isActive(this)) {
            graphics.setColor(McWinLookAndFeel.getWindowBorderColor());
        } else {
            graphics.setColor(McWinLookAndFeel.getWindowInactiveBorderColor());
        }
        graphics.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }

    private class TitleButton
    extends NoFocusButton {
        private TitleButton() {
        }

        public void paint(Graphics graphics) {
            if (JTattooUtilities.isActive(this)) {
                super.paint(graphics);
            } else {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Composite composite = graphics2D.getComposite();
                AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.6f);
                graphics2D.setComposite(alphaComposite);
                super.paint(graphics);
                graphics2D.setComposite(composite);
            }
        }
    }
}

