/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.mcwin;

import com.jtattoo.plaf.BaseIcons;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.mcwin.icons.ImageHelper;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.plaf.UIResource;

public class McWinIcons
extends BaseIcons {
    private static Icon radioButtonIcon;
    private static Icon checkBoxIcon;
    private static Icon thumbIcon;
    private static Icon thumbIconRollover;

    public static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    public static Icon getThumbHorIcon() {
        if (thumbIcon == null) {
            thumbIcon = ImageHelper.loadImage("pearl_white.gif");
        }
        return thumbIcon;
    }

    public static Icon getThumbVerIcon() {
        if (thumbIcon == null) {
            thumbIcon = ImageHelper.loadImage("pearl_white.gif");
        }
        return thumbIcon;
    }

    public static Icon getThumbHorIconRollover() {
        if (thumbIconRollover == null) {
            thumbIconRollover = ImageHelper.loadImage("pearl_green.gif");
        }
        return thumbIconRollover;
    }

    public static Icon getThumbVerIconRollover() {
        if (thumbIconRollover == null) {
            thumbIconRollover = ImageHelper.loadImage("pearl_green.gif");
        }
        return thumbIconRollover;
    }

    static {
        thumbIcon = null;
        thumbIconRollover = null;
    }

    private static class RadioButtonIcon
    implements Icon,
    UIResource {
        private ImageIcon radioIcon = ImageHelper.loadImage("pearl_white.gif");
        private ImageIcon radioSelectedIcon = ImageHelper.loadImage("pearl_blue_selected.gif");
        private ImageIcon radioRolloverIcon = ImageHelper.loadImage("pearl_green.gif");
        private ImageIcon radioRolloverSelectedIcon = ImageHelper.loadImage("pearl_green_selected.gif");
        private ImageIcon radioDisabledSelectedIcon = ImageHelper.loadImage("pearl_white_selected.gif");

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (!JTattooUtilities.isLeftToRight(component)) {
                n += 2;
            }
            JRadioButton jRadioButton = (JRadioButton)component;
            ButtonModel buttonModel = jRadioButton.getModel();
            if (jRadioButton.isEnabled()) {
                if (buttonModel.isSelected()) {
                    if (jRadioButton.isRolloverEnabled() && buttonModel.isRollover()) {
                        this.radioRolloverSelectedIcon.paintIcon(component, graphics, n, n2);
                    } else if (JTattooUtilities.isFrameActive(jRadioButton)) {
                        this.radioSelectedIcon.paintIcon(component, graphics, n, n2);
                    } else {
                        this.radioDisabledSelectedIcon.paintIcon(component, graphics, n, n2);
                    }
                } else if (jRadioButton.isRolloverEnabled() && buttonModel.isRollover()) {
                    this.radioRolloverIcon.paintIcon(component, graphics, n, n2);
                } else {
                    this.radioIcon.paintIcon(component, graphics, n, n2);
                }
            } else if (buttonModel.isSelected()) {
                this.radioDisabledSelectedIcon.paintIcon(component, graphics, n, n2);
            } else {
                this.radioIcon.paintIcon(component, graphics, n, n2);
            }
        }

        public int getIconWidth() {
            return this.radioIcon.getIconWidth() + 2;
        }

        public int getIconHeight() {
            return this.radioIcon.getIconHeight();
        }
    }

    private static class CheckBoxIcon
    implements Icon,
    UIResource {
        private ImageIcon checkIcon = ImageHelper.loadImage("check.gif");
        private ImageIcon checkSelectedIcon = ImageHelper.loadImage("check_selected.gif");
        private ImageIcon checkPressedIcon = ImageHelper.loadImage("check_pressed.gif");
        private ImageIcon checkRolloverIcon = ImageHelper.loadImage("check_rollover.gif");
        private ImageIcon checkRolloverSelectedIcon = ImageHelper.loadImage("check_rollover_selected.gif");
        private ImageIcon checkDisabledSelectedIcon = ImageHelper.loadImage("check_disabled_selected.gif");

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (!JTattooUtilities.isLeftToRight(component)) {
                n += 2;
            }
            JCheckBox jCheckBox = (JCheckBox)component;
            ButtonModel buttonModel = jCheckBox.getModel();
            if (jCheckBox.isEnabled()) {
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    this.checkPressedIcon.paintIcon(component, graphics, n, n2);
                } else if (buttonModel.isSelected()) {
                    if (jCheckBox.isRolloverEnabled() && buttonModel.isRollover()) {
                        this.checkRolloverSelectedIcon.paintIcon(component, graphics, n, n2);
                    } else if (JTattooUtilities.isFrameActive(jCheckBox)) {
                        this.checkSelectedIcon.paintIcon(component, graphics, n, n2);
                    } else {
                        this.checkDisabledSelectedIcon.paintIcon(component, graphics, n, n2);
                    }
                } else if (jCheckBox.isRolloverEnabled() && buttonModel.isRollover()) {
                    this.checkRolloverIcon.paintIcon(component, graphics, n, n2);
                } else {
                    this.checkIcon.paintIcon(component, graphics, n, n2);
                }
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                this.checkPressedIcon.paintIcon(component, graphics, n, n2);
            } else if (buttonModel.isSelected()) {
                this.checkDisabledSelectedIcon.paintIcon(component, graphics, n, n2);
            } else {
                this.checkIcon.paintIcon(component, graphics, n, n2);
            }
        }

        public int getIconWidth() {
            return this.checkIcon.getIconWidth() + 2;
        }

        public int getIconHeight() {
            return this.checkIcon.getIconHeight();
        }
    }
}

