/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.mcwin;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseBorders;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.mcwin.McWinLookAndFeel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class McWinBorders
extends BaseBorders {
    private static Border popupMenuBorder = null;
    private static Border buttonBorder = null;
    private static Border toolButtonBorder = null;
    private static Border rolloverToolButtonBorder = null;
    private static Border internalFrameBorder = null;

    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new ButtonBorder();
        }
        return buttonBorder;
    }

    public static Border getToggleButtonBorder() {
        return McWinBorders.getButtonBorder();
    }

    public static Border getToolButtonBorder() {
        if (toolButtonBorder == null) {
            toolButtonBorder = new ToolButtonBorder();
        }
        return McWinBorders.getButtonBorder();
    }

    public static Border getRolloverToolButtonBorder() {
        if (rolloverToolButtonBorder == null) {
            rolloverToolButtonBorder = new RolloverToolButtonBorder();
        }
        return rolloverToolButtonBorder;
    }

    public static Border getPopupMenuBorder() {
        if (popupMenuBorder == null) {
            popupMenuBorder = new PopupMenuBorder();
        }
        return popupMenuBorder;
    }

    public static Border getInternalFrameBorder() {
        if (internalFrameBorder == null) {
            internalFrameBorder = new InternalFrameBorder();
        }
        return internalFrameBorder;
    }

    public static class PopupMenuBorder
    extends AbstractBorder
    implements UIResource {
        private static final Font logoFont = new Font("Dialog", 1, 12);
        private static final int shadowSize = 3;
        private static final Insets logoInsets = new Insets(2, 18, 4, 4);
        private static final Insets insets = new Insets(2, 1, 4, 4);

        public boolean hasLogo() {
            return AbstractLookAndFeel.getTheme().getLogoString() != null && AbstractLookAndFeel.getTheme().getLogoString().length() > 0;
        }

        public void paintLogo(Graphics2D graphics2D, int n, int n2) {
            BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
            Graphics2D graphics2D2 = bufferedImage.createGraphics();
            ColorUIResource colorUIResource = AbstractLookAndFeel.getTheme().getMenuSelectionBackgroundColor();
            graphics2D2.setColor(colorUIResource);
            graphics2D2.fillRect(0, 0, n, n2);
            graphics2D2.setFont(logoFont);
            FontMetrics fontMetrics = graphics2D2.getFontMetrics();
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.setToRotation(4.71238898038469);
            graphics2D2.setTransform(affineTransform);
            int n3 = -n2 + 4;
            int n4 = fontMetrics.getAscent() + 2;
            graphics2D2.setColor(ColorHelper.darker(colorUIResource, 20.0));
            graphics2D2.drawString(JTattooUtilities.getClippedText(AbstractLookAndFeel.getTheme().getLogoString(), fontMetrics, n2 - 16), n3 - 1, n4 + 1);
            graphics2D2.setColor(Color.white);
            graphics2D2.drawString(JTattooUtilities.getClippedText(AbstractLookAndFeel.getTheme().getLogoString(), fontMetrics, n2 - 16), n3, n4);
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, n, n2);
            TexturePaint texturePaint = new TexturePaint(bufferedImage, double_);
            graphics2D.setPaint(texturePaint);
            graphics2D.fillRect(0, 0, n, n2);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            AlphaComposite alphaComposite = null;
            Composite composite = graphics2D.getComposite();
            if (!McWinLookAndFeel.getTheme().isMenuOpaque()) {
                alphaComposite = AlphaComposite.getInstance(3, 0.6f);
                graphics2D.setComposite(alphaComposite);
            }
            int n5 = this.getBorderInsets((Component)component).left;
            ColorUIResource colorUIResource = AbstractLookAndFeel.getTheme().getMenuSelectionBackgroundColor();
            graphics.setColor(colorUIResource);
            graphics.fillRect(n, n2, n5 - 1, n4 - 1 - 3);
            if (this.hasLogo()) {
                this.paintLogo(graphics2D, n5, n4 - 3);
            }
            graphics.setColor(ColorHelper.brighter(colorUIResource, 50.0));
            graphics.drawLine(n + 1, n2 + 1, n + n5, n2 + 1);
            graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + n4 - 3 - 1);
            graphics.setColor(Color.white);
            graphics.drawLine(n + n5, n2 + 1, n + n3 - 2, n2 + 1);
            graphics.setColor(ColorHelper.darker(colorUIResource, 30.0));
            graphics.drawLine(n + n5 - 1, n2 + 1, n + n5 - 1, n2 + n4 - 3 - 1);
            graphics.setColor(AbstractLookAndFeel.getFrameColor());
            graphics.drawRect(n, n2, n3 - 3 - 1, n4 - 3 - 1);
            graphics2D.setColor(Color.black);
            float f = 0.6f;
            for (int i = 0; i < 3; ++i) {
                alphaComposite = AlphaComposite.getInstance(3, f);
                graphics2D.setComposite(alphaComposite);
                graphics.drawLine(n + n3 - 3 + i, n2 + 3, n + n3 - 3 + i, n2 + n4 - 3 - 1 + i);
                graphics.drawLine(n + 3, n2 + n4 - 3 + i, n + n3 - 3 + i, n2 + n4 - 3 + i);
                f -= f / 2.0f;
            }
            graphics2D.setComposite(composite);
        }

        public Insets getBorderInsets(Component component) {
            if (this.hasLogo()) {
                return logoInsets;
            }
            return insets;
        }
    }

    public static class InternalFrameBorder
    extends BaseBorders.BaseInternalFrameBorder {
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            boolean bl = this.isActive(component);
            boolean bl2 = this.isResizable(component);
            int n5 = this.getTitleHeight(component);
            ColorUIResource colorUIResource = McWinLookAndFeel.getWindowInactiveBorderColor();
            ColorUIResource colorUIResource2 = McWinLookAndFeel.getWindowInactiveTitleColorLight();
            ColorUIResource colorUIResource3 = McWinLookAndFeel.getWindowInactiveTitleColorDark();
            if (bl) {
                colorUIResource = McWinLookAndFeel.getWindowBorderColor();
                colorUIResource2 = McWinLookAndFeel.getWindowTitleColorLight();
                colorUIResource3 = McWinLookAndFeel.getWindowTitleColorDark();
            }
            if (!bl2) {
                Insets insets = this.getBorderInsets(component);
                graphics.setColor(colorUIResource);
                graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                if (bl) {
                    graphics.setColor(McWinLookAndFeel.getWindowTitleColorDark());
                } else {
                    graphics.setColor(McWinLookAndFeel.getWindowInactiveTitleColorDark());
                }
                for (int i = 1; i < insets.left; ++i) {
                    graphics.drawRect(i, i, n3 - 2 * i - 1, n4 - 2 * i - 1);
                }
                graphics.setColor(ColorHelper.brighter(colorUIResource, 20.0));
                graphics.drawLine(insets.left - 1, n2 + n5 + insets.top, insets.left - 1, n2 + n4 - insets.bottom);
                graphics.drawLine(n3 - insets.right, n2 + n5 + insets.top, n3 - insets.right, n2 + n4 - insets.bottom);
                graphics.drawLine(insets.left - 1, n2 + n4 - insets.bottom, n3 - insets.right, n2 + n4 - insets.bottom);
                return;
            }
            graphics.setColor(colorUIResource2);
            graphics.fillRect(n, n2 + 1, n3, 4);
            graphics.setColor(colorUIResource3);
            graphics.fillRect(n + 1, n2 + n4 - 5, n3 - 2, 4);
            if (bl) {
                JTattooUtilities.fillHorGradient(graphics, McWinLookAndFeel.getTheme().getWindowTitleColors(), 1, 5, 5, n5 + 1);
                JTattooUtilities.fillHorGradient(graphics, McWinLookAndFeel.getTheme().getWindowTitleColors(), n3 - 5, 5, 5, n5 + 1);
            } else {
                JTattooUtilities.fillHorGradient(graphics, McWinLookAndFeel.getTheme().getWindowInactiveTitleColors(), 1, 5, 5, n5 + 1);
                JTattooUtilities.fillHorGradient(graphics, McWinLookAndFeel.getTheme().getWindowInactiveTitleColors(), n3 - 5, 5, 5, n5 + 1);
            }
            graphics.setColor(colorUIResource3);
            graphics.fillRect(1, this.insets.top + n5 + 1, 4, n4 - n5 - 5);
            graphics.fillRect(n3 - 5, this.insets.top + n5 + 1, 4, n4 - n5 - 5);
            graphics.setColor(ColorHelper.darker(colorUIResource, 10.0));
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
            graphics.setColor(colorUIResource);
            graphics.drawLine(n + 5 - 1, n2 + 5 + n5, n + 5 - 1, n2 + n4 - 5);
            graphics.drawLine(n + n3 - 5, n2 + 5 + n5, n + n3 - 5, n2 + n4 - 5);
            graphics.drawLine(n + 5 - 1, n2 + n4 - 5, n + n3 - 5, n2 + n4 - 5);
        }
    }

    public static class RolloverToolButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(2, 3, 2, 3);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (buttonModel.isPressed() && buttonModel.isArmed() || buttonModel.isSelected()) {
                JTattooUtilities.draw3DBorder(graphics, Color.lightGray, Color.white, n, n2, n3 - 2, n4 - 1);
            } else if (buttonModel.isRollover()) {
                JTattooUtilities.draw3DBorder(graphics, Color.white, Color.lightGray, n + 1, n2 + 1, n3 - 3, n4 - 2);
            }
            graphics.setColor(Color.lightGray);
            graphics.drawRect(n, n2, n3 - 2, n4 - 1);
            graphics.setColor(Color.white);
            graphics.drawLine(n3 - 1, 0, n3 - 1, n4 - 1);
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ToolButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(2, 3, 2, 3);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (buttonModel.isPressed() && buttonModel.isArmed() || buttonModel.isSelected()) {
                JTattooUtilities.draw3DBorder(graphics, Color.lightGray, Color.white, n, n2, n3 - 2, n4 - 1);
            }
            graphics.setColor(Color.lightGray);
            graphics.drawRect(n, n2, n3 - 2, n4 - 1);
            graphics.setColor(Color.white);
            graphics.drawLine(n3 - 1, 0, n3 - 1, n4 - 1);
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(2, 12, 2, 12);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }

        public boolean isBorderOpaque() {
            return false;
        }
    }
}

