/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.luna;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseRootPaneUI;
import com.jtattoo.plaf.BaseTitlePane;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.DecorationHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.NoFocusButton;
import com.jtattoo.plaf.luna.LunaIcons;
import com.jtattoo.plaf.luna.LunaLookAndFeel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JRootPane;
import javax.swing.plaf.ColorUIResource;

public class LunaTitlePane
extends BaseTitlePane {
    protected static final Icon iconIcon = LunaIcons.getIconButtonIcon();
    protected static final Icon minIcon = LunaIcons.getMinButtonIcon();
    protected static final Icon maxIcon = LunaIcons.getMaxButtonIcon();
    protected static final Icon closeIcon = LunaIcons.getCloseButtonIcon();

    public LunaTitlePane(JRootPane jRootPane, BaseRootPaneUI baseRootPaneUI) {
        super(jRootPane, baseRootPaneUI);
    }

    protected int getHorSpacing() {
        return 2;
    }

    protected int getVerSpacing() {
        return 5;
    }

    public void createButtons() {
        this.maximizeIcon = maxIcon;
        this.minimizeIcon = minIcon;
        this.closeButton = new TitleButton(this.closeAction, "Close");
        this.iconifyButton = new TitleButton(this.iconifyAction, "Iconify");
        this.maxButton = new TitleButton(this.restoreAction, "Maximize");
        this.setButtonIcons();
    }

    protected void setButtonIcons() {
        this.iconifyButton.setIcon(iconIcon);
        if ((this.state & 6) == 0) {
            this.maxButton.setIcon(maxIcon);
        } else {
            this.maxButton.setIcon(minIcon);
        }
        this.closeButton.setIcon(closeIcon);
    }

    protected void updateMaxButton(Action action, Icon icon) {
        this.maxButton.setAction(action);
        if ((this.state & 6) == 0) {
            this.maxButton.setIcon(minIcon);
        } else {
            this.maxButton.setIcon(maxIcon);
        }
    }

    protected void setActive(boolean bl) {
        super.setActive(bl);
        this.setButtonIcons();
    }

    public void paintBackground(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        Color color = null;
        if (this.isActive()) {
            color = AbstractLookAndFeel.getTheme().getFrameColor();
            JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getWindowTitleColors(), 0, 0, n, n2);
        } else {
            color = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getFrameColor(), 40.0);
            JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), 0, 0, n, n2);
        }
        graphics.setColor(color);
        graphics.drawLine(0, n2 - 1, n, n2 - 1);
    }

    public void paintComponent(Graphics graphics) {
        int n;
        if (this.getFrame() != null) {
            this.setState(DecorationHelper.getExtendedState(this.getFrame()));
        }
        this.paintBackground(graphics);
        boolean bl = this.isLeftToRight();
        boolean bl2 = this.window == null ? true : JTattooUtilities.isWindowActive(this.window);
        ColorUIResource colorUIResource = AbstractLookAndFeel.getWindowInactiveTitleForegroundColor();
        if (bl2) {
            colorUIResource = AbstractLookAndFeel.getWindowTitleForegroundColor();
        }
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        int n4 = n2 - this.buttonsWidth - 10;
        int n5 = n = bl ? 5 : n2 - 5;
        if (this.getWindowDecorationStyle() == 1) {
            n += bl ? n3 : -n3;
            n4 -= n3;
        }
        graphics.setFont(this.getFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = JTattooUtilities.getClippedText(this.getTitle(), fontMetrics, n4);
        if (string != null) {
            int n6 = fontMetrics.stringWidth(string);
            int n7 = (n3 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent();
            if (!bl) {
                n -= n6;
            }
            if (bl2) {
                graphics.setColor(LunaLookAndFeel.getTheme().getWindowBorderColor());
                JTattooUtilities.drawString(this.rootPane, graphics, string, n - 1, n7 - 1);
                JTattooUtilities.drawString(this.rootPane, graphics, string, n + 1, n7 + 1);
            }
            graphics.setColor(colorUIResource);
            JTattooUtilities.drawString(this.rootPane, graphics, string, n, n7);
            this.paintText(graphics, n, n7, string);
        }
    }

    private class TitleButton
    extends NoFocusButton {
        public TitleButton(Action action, String string) {
            this.setContentAreaFilled(false);
            this.setBorderPainted(false);
            this.setAction(action);
            this.setText(null);
            this.putClientProperty("paintActive", Boolean.TRUE);
            this.getAccessibleContext().setAccessibleName(string);
        }

        public void paint(Graphics graphics) {
            if (JTattooUtilities.isWindowActive(LunaTitlePane.this.window)) {
                super.paint(graphics);
            } else {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Composite composite = graphics2D.getComposite();
                AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.6f);
                graphics2D.setComposite(alphaComposite);
                super.paint(graphics);
                graphics2D.setComposite(composite);
            }
        }
    }
}

