/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.acryl;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseComboBoxUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.acryl.AcrylIcons;
import com.jtattoo.plaf.acryl.AcrylLookAndFeel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.ComponentUI;

public class AcrylComboBoxUI
extends BaseComboBoxUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new AcrylComboBoxUI();
    }

    public JButton createArrowButton() {
        ArrowButton arrowButton = new ArrowButton();
        Color color = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getFrameColor(), 50.0);
        if (JTattooUtilities.isLeftToRight(this.comboBox)) {
            MatteBorder matteBorder = BorderFactory.createMatteBorder(0, 1, 0, 0, color);
            arrowButton.setBorder(matteBorder);
        } else {
            MatteBorder matteBorder = BorderFactory.createMatteBorder(0, 0, 0, 1, color);
            arrowButton.setBorder(matteBorder);
        }
        return arrowButton;
    }

    static class ArrowButton
    extends JButton {
        ArrowButton() {
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            if (this.isEnabled()) {
                if (this.getModel().isArmed() && this.getModel().isPressed()) {
                    JTattooUtilities.fillHorGradient(graphics, AcrylLookAndFeel.getTheme().getSelectedColors(), 0, 0, dimension.width, dimension.height);
                } else if (this.getModel().isRollover()) {
                    JTattooUtilities.fillHorGradient(graphics, AcrylLookAndFeel.getTheme().getRolloverColors(), 0, 0, dimension.width, dimension.height);
                } else if (JTattooUtilities.isActive(this)) {
                    JTattooUtilities.fillHorGradient(graphics, AcrylLookAndFeel.getTheme().getButtonColors(), 0, 0, dimension.width, dimension.height);
                } else {
                    JTattooUtilities.fillHorGradient(graphics, AcrylLookAndFeel.getTheme().getInActiveColors(), 0, 0, dimension.width, dimension.height);
                }
            } else {
                JTattooUtilities.fillHorGradient(graphics, AcrylLookAndFeel.getTheme().getDisabledColors(), 0, 0, dimension.width, dimension.height);
            }
            Icon icon = AcrylIcons.getComboBoxIcon();
            int n = (dimension.width - icon.getIconWidth()) / 2;
            int n2 = (dimension.height - icon.getIconHeight()) / 2;
            icon.paintIcon(this, graphics, n + 1, n2);
            this.paintBorder(graphics);
        }
    }
}

