/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;

public class BaseInternalFrameTitlePane
extends BasicInternalFrameTitlePane
implements ActionListener {
    private static final String PAINT_ACTIVE = "paintActive";
    protected boolean isPalette = false;
    protected Icon paletteCloseIcon;
    protected int paletteTitleHeight;
    protected int buttonsWidth = 0;

    public BaseInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    protected void installDefaults() {
        super.installDefaults();
        this.setFont(UIManager.getFont("InternalFrame.font"));
        this.paletteTitleHeight = UIManager.getInt("InternalFrame.paletteTitleHeight");
        this.paletteCloseIcon = UIManager.getIcon("InternalFrame.paletteCloseIcon");
    }

    protected void createButtons() {
        super.createButtons();
        Boolean bl = this.isActive() ? Boolean.TRUE : Boolean.FALSE;
        this.iconButton.setOpaque(false);
        this.iconButton.putClientProperty(PAINT_ACTIVE, bl);
        this.iconButton.getAccessibleContext().setAccessibleName("Iconify");
        this.iconButton.addActionListener(this);
        this.maxButton.setOpaque(false);
        this.maxButton.putClientProperty(PAINT_ACTIVE, bl);
        this.maxButton.getAccessibleContext().setAccessibleName("Maximize");
        this.maxButton.addActionListener(this);
        this.closeButton.setOpaque(false);
        this.closeButton.putClientProperty(PAINT_ACTIVE, bl);
        this.closeButton.getAccessibleContext().setAccessibleName("Close");
        this.closeButton.addActionListener(this);
    }

    protected void assembleSystemMenu() {
    }

    protected void addSystemMenuItems(JMenu jMenu) {
    }

    protected void addSubComponents() {
        this.add(this.iconButton);
        this.add(this.maxButton);
        this.add(this.closeButton);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new BasePropertyChangeHandler();
    }

    protected LayoutManager createLayout() {
        return new BaseTitlePaneLayout();
    }

    protected int getHorSpacing() {
        return 3;
    }

    protected int getVerSpacing() {
        return 4;
    }

    public void activateFrame() {
    }

    public void deactivateFrame() {
    }

    public boolean isActive() {
        return JTattooUtilities.isActive(this);
    }

    public boolean isPalette() {
        return this.isPalette;
    }

    public void setPalette(boolean bl) {
        this.isPalette = bl;
        if (this.isPalette) {
            this.closeButton.setIcon(this.paletteCloseIcon);
            if (this.frame.isMaximizable()) {
                this.remove(this.maxButton);
            }
            if (this.frame.isIconifiable()) {
                this.remove(this.iconButton);
            }
        } else {
            this.closeButton.setIcon(this.closeIcon);
            if (this.frame.isMaximizable()) {
                this.add(this.maxButton);
            }
            if (this.frame.isIconifiable()) {
                this.add(this.iconButton);
            }
        }
        this.revalidate();
        this.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
        abstractButton.getModel().setRollover(false);
    }

    public void paintPalette(Graphics graphics) {
        if (JTattooUtilities.isFrameActive(this)) {
            graphics.setColor(AbstractLookAndFeel.getWindowTitleBackgroundColor());
        } else {
            graphics.setColor(AbstractLookAndFeel.getWindowInactiveTitleBackgroundColor());
        }
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public void paintBackground(Graphics graphics) {
        if (this.isActive()) {
            graphics.setColor(AbstractLookAndFeel.getWindowTitleBackgroundColor());
        } else {
            graphics.setColor(AbstractLookAndFeel.getWindowInactiveTitleBackgroundColor());
        }
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public void paintText(Graphics graphics, int n, int n2, String string) {
        if (this.isActive()) {
            graphics.setColor(AbstractLookAndFeel.getWindowTitleForegroundColor());
        } else {
            graphics.setColor(AbstractLookAndFeel.getWindowInactiveTitleForegroundColor());
        }
        JTattooUtilities.drawString(this.frame, graphics, string, n, n2);
    }

    public void paintBorder(Graphics graphics) {
        ColorUIResource colorUIResource = AbstractLookAndFeel.getWindowInactiveBorderColor();
        if (this.isActive() || this.isPalette) {
            colorUIResource = AbstractLookAndFeel.getWindowBorderColor();
        }
        JTattooUtilities.draw3DBorder(graphics, ColorHelper.brighter(colorUIResource, 20.0), ColorHelper.darker(colorUIResource, 10.0), 0, 0, this.getWidth(), this.getHeight());
    }

    public void paintComponent(Graphics graphics) {
        if (this.isPalette) {
            this.paintPalette(graphics);
            return;
        }
        this.paintBackground(graphics);
        boolean bl = JTattooUtilities.isLeftToRight(this.frame);
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = bl ? 5 : n - 5;
        int n4 = n - this.buttonsWidth - 10;
        Icon icon = this.frame.getFrameIcon();
        if (icon != null) {
            if (!bl) {
                n3 -= icon.getIconWidth();
            }
            int n5 = n2 / 2 - icon.getIconHeight() / 2;
            icon.paintIcon(this.frame, graphics, n3, n5);
            n3 += bl ? icon.getIconWidth() + 5 : -5;
            n4 -= icon.getIconWidth() + 5;
        }
        graphics.setFont(this.getFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = JTattooUtilities.getClippedText(this.frame.getTitle(), fontMetrics, n4);
        int n6 = fontMetrics.stringWidth(string);
        int n7 = (n2 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent();
        if (!bl) {
            n3 -= n6;
        }
        this.paintText(graphics, n3, n7, string);
        this.paintBorder(graphics);
    }

    class BaseTitlePaneLayout
    extends BasicInternalFrameTitlePane.TitlePaneLayout {
        BaseTitlePaneLayout() {
            super(BaseInternalFrameTitlePane.this);
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        public Dimension minimumLayoutSize(Container container) {
            int n;
            int n2;
            int n3 = 30;
            if (BaseInternalFrameTitlePane.this.frame.isClosable()) {
                n3 += 21;
            }
            if (BaseInternalFrameTitlePane.this.frame.isMaximizable()) {
                n3 += 16 + (BaseInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4);
            }
            if (BaseInternalFrameTitlePane.this.frame.isIconifiable()) {
                n3 += 16 + (BaseInternalFrameTitlePane.this.frame.isMaximizable() ? 2 : (BaseInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4));
            }
            FontMetrics fontMetrics = BaseInternalFrameTitlePane.this.getFontMetrics(BaseInternalFrameTitlePane.this.getFont());
            String string = BaseInternalFrameTitlePane.this.frame.getTitle();
            int n4 = string != null ? fontMetrics.stringWidth(string) : 0;
            int n5 = n2 = string != null ? string.length() : 0;
            n3 = n2 > 2 ? (n3 += n4 < (n = fontMetrics.stringWidth(BaseInternalFrameTitlePane.this.frame.getTitle().substring(0, 2) + "...")) ? n4 : n) : (n3 += n4);
            n = BaseInternalFrameTitlePane.this.paletteTitleHeight;
            if (!BaseInternalFrameTitlePane.this.isPalette) {
                int n6 = fontMetrics.getHeight() + 7;
                Icon icon = BaseInternalFrameTitlePane.this.frame.getFrameIcon();
                int n7 = 0;
                if (icon != null) {
                    n7 = Math.min(icon.getIconHeight(), 18);
                }
                n = Math.max(n6, n7 += 5);
            }
            return new Dimension(n3, n);
        }

        public void layoutContainer(Container container) {
            int n;
            boolean bl = JTattooUtilities.isLeftToRight(BaseInternalFrameTitlePane.this.frame);
            int n2 = BaseInternalFrameTitlePane.this.getHorSpacing();
            int n3 = BaseInternalFrameTitlePane.this.getWidth();
            int n4 = BaseInternalFrameTitlePane.this.getHeight();
            int n5 = n = n4 - BaseInternalFrameTitlePane.this.getVerSpacing();
            int n6 = bl ? n3 - n2 : 0;
            int n7 = Math.max(0, (n4 - n) / 2 - 1);
            if (BaseInternalFrameTitlePane.this.frame.isClosable()) {
                BaseInternalFrameTitlePane.this.closeButton.setBounds(n6 += bl ? -n5 : n2, n7, n5, n);
                if (!bl) {
                    n6 += n5;
                }
            }
            if (BaseInternalFrameTitlePane.this.frame.isMaximizable() && !BaseInternalFrameTitlePane.this.isPalette) {
                BaseInternalFrameTitlePane.this.maxButton.setBounds(n6 += bl ? -n2 - n5 : n2, n7, n5, n);
                if (!bl) {
                    n6 += n5;
                }
            }
            if (BaseInternalFrameTitlePane.this.frame.isIconifiable() && !BaseInternalFrameTitlePane.this.isPalette) {
                BaseInternalFrameTitlePane.this.iconButton.setBounds(n6 += bl ? -n2 - n5 : n2, n7, n5, n);
                if (!bl) {
                    n6 += n5;
                }
            }
            BaseInternalFrameTitlePane.this.buttonsWidth = bl ? n3 - n6 : n6;
        }
    }

    class BasePropertyChangeHandler
    extends BasicInternalFrameTitlePane.PropertyChangeHandler {
        BasePropertyChangeHandler() {
            super(BaseInternalFrameTitlePane.this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("selected")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                BaseInternalFrameTitlePane.this.iconButton.putClientProperty(BaseInternalFrameTitlePane.PAINT_ACTIVE, bl);
                BaseInternalFrameTitlePane.this.closeButton.putClientProperty(BaseInternalFrameTitlePane.PAINT_ACTIVE, bl);
                BaseInternalFrameTitlePane.this.maxButton.putClientProperty(BaseInternalFrameTitlePane.PAINT_ACTIVE, bl);
                if (bl.booleanValue()) {
                    BaseInternalFrameTitlePane.this.activateFrame();
                } else {
                    BaseInternalFrameTitlePane.this.deactivateFrame();
                }
                BaseInternalFrameTitlePane.this.repaint();
            }
            super.propertyChange(propertyChangeEvent);
        }
    }
}

