/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicToolBarUI;

public abstract class AbstractToolBarUI
extends BasicToolBarUI {
    private static final String IS_ROLLOVER = "JToolBar.isRollover";
    private static final Insets BUTTON_MARGIN = new Insets(1, 1, 1, 1);
    private boolean isRolloverEnabled = true;
    private MyPropertyChangeListener propertyChangeListener = null;
    private MyContainerListener containerListener = null;
    private Hashtable orgBorders = new Hashtable();
    private Hashtable orgMargins = new Hashtable();

    public abstract Border getRolloverBorder();

    public abstract Border getNonRolloverBorder();

    public abstract boolean isButtonOpaque();

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        Boolean bl = (Boolean)UIManager.get(IS_ROLLOVER);
        if (bl != null) {
            this.isRolloverEnabled = bl;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AbstractToolBarUI.this.changeBorders();
            }
        });
    }

    public void uninstallUI(JComponent jComponent) {
        this.restoreBorders();
        super.uninstallUI(jComponent);
    }

    protected void installListeners() {
        super.installListeners();
        this.propertyChangeListener = new MyPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.toolBar.addPropertyChangeListener(this.propertyChangeListener);
        }
        this.containerListener = new MyContainerListener();
        if (this.containerListener != null) {
            this.toolBar.addContainerListener(this.containerListener);
        }
    }

    protected void uninstallListeners() {
        if (this.propertyChangeListener != null) {
            this.toolBar.removePropertyChangeListener(this.propertyChangeListener);
        }
        this.propertyChangeListener = null;
        if (this.containerListener != null) {
            this.toolBar.removeContainerListener(this.containerListener);
        }
        this.containerListener = null;
        super.uninstallListeners();
    }

    protected void changeBorders() {
        Component[] componentArray = this.toolBar.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (!(component instanceof AbstractButton)) continue;
            this.changeButtonBorder((AbstractButton)component);
        }
    }

    protected void restoreBorders() {
        Component[] componentArray = this.toolBar.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (!(component instanceof AbstractButton)) continue;
            this.restoreButtonBorder((AbstractButton)component);
        }
    }

    protected void changeButtonBorder(AbstractButton abstractButton) {
        if (!this.orgBorders.contains(abstractButton)) {
            this.orgBorders.put(abstractButton, abstractButton.getBorder());
        }
        if (!this.orgMargins.contains(abstractButton)) {
            this.orgMargins.put(abstractButton, abstractButton.getMargin());
        }
        if (this.isRolloverEnabled) {
            abstractButton.setBorderPainted(true);
            abstractButton.setBorder(this.getRolloverBorder());
            abstractButton.setMargin(BUTTON_MARGIN);
            abstractButton.setRolloverEnabled(true);
            abstractButton.setOpaque(this.isButtonOpaque());
            abstractButton.setContentAreaFilled(this.isButtonOpaque());
        } else {
            abstractButton.setBorder(this.getNonRolloverBorder());
            abstractButton.setMargin(BUTTON_MARGIN);
            abstractButton.setRolloverEnabled(false);
            abstractButton.setOpaque(this.isButtonOpaque());
            abstractButton.setContentAreaFilled(this.isButtonOpaque());
        }
    }

    protected void restoreButtonBorder(AbstractButton abstractButton) {
        Border border = (Border)this.orgBorders.get(abstractButton);
        if (border != null) {
            abstractButton.setBorder(border);
        }
        Insets insets = (Insets)this.orgMargins.get(abstractButton);
        abstractButton.setMargin(insets);
    }

    protected void updateToolbarBorder() {
        this.toolBar.revalidate();
        this.toolBar.repaint();
    }

    protected class MyContainerListener
    implements ContainerListener {
        protected MyContainerListener() {
        }

        public void componentAdded(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (component instanceof AbstractButton) {
                AbstractToolBarUI.this.changeButtonBorder((AbstractButton)component);
            }
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (component instanceof AbstractButton) {
                AbstractToolBarUI.this.restoreButtonBorder((AbstractButton)component);
            }
        }
    }

    protected class MyPropertyChangeListener
    implements PropertyChangeListener {
        protected MyPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(AbstractToolBarUI.IS_ROLLOVER)) {
                if (propertyChangeEvent.getNewValue() != null) {
                    AbstractToolBarUI.this.isRolloverEnabled = (Boolean)propertyChangeEvent.getNewValue();
                    AbstractToolBarUI.this.changeBorders();
                }
            } else if ("componentOrientation".equals(propertyChangeEvent.getPropertyName())) {
                AbstractToolBarUI.this.updateToolbarBorder();
            }
        }
    }
}

