/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.mcwin;

import com.jtattoo.plaf.BaseComboBoxUI;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.mcwin.McWinIcons;
import com.jtattoo.plaf.mcwin.McWinLookAndFeel;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.ComponentUI;

public class McWinComboBoxUI
extends BaseComboBoxUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new McWinComboBoxUI();
    }

    public JButton createArrowButton() {
        ArrowButton arrowButton = new ArrowButton();
        if (JTattooUtilities.isLeftToRight(this.comboBox)) {
            MatteBorder matteBorder = BorderFactory.createMatteBorder(0, 1, 0, 0, McWinLookAndFeel.getFrameColor());
            arrowButton.setBorder(matteBorder);
        } else {
            MatteBorder matteBorder = BorderFactory.createMatteBorder(0, 0, 0, 1, McWinLookAndFeel.getFrameColor());
            arrowButton.setBorder(matteBorder);
        }
        return arrowButton;
    }

    static class ArrowButton
    extends JButton {
        ArrowButton() {
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            if (this.isEnabled()) {
                if (this.getModel().isArmed() && this.getModel().isPressed()) {
                    JTattooUtilities.fillHorGradient(graphics, McWinLookAndFeel.getTheme().getSelectedColors(), 0, 0, dimension.width, dimension.height);
                } else if (this.getModel().isRollover()) {
                    JTattooUtilities.fillHorGradient(graphics, McWinLookAndFeel.getTheme().getRolloverColors(), 0, 0, dimension.width, dimension.height);
                } else if (JTattooUtilities.isActive(this)) {
                    JTattooUtilities.fillHorGradient(graphics, McWinLookAndFeel.getTheme().getDefaultColors(), 0, 0, dimension.width, dimension.height);
                } else {
                    JTattooUtilities.fillHorGradient(graphics, McWinLookAndFeel.getTheme().getInActiveColors(), 0, 0, dimension.width, dimension.height);
                }
            } else {
                JTattooUtilities.fillHorGradient(graphics, McWinLookAndFeel.getTheme().getDisabledColors(), 0, 0, dimension.width, dimension.height);
            }
            Icon icon = McWinIcons.getComboBoxIcon();
            int n = (dimension.width - icon.getIconWidth() + 1) / 2;
            int n2 = (dimension.height - icon.getIconHeight()) / 2;
            icon.paintIcon(this, graphics, n, n2);
            this.paintBorder(graphics);
        }
    }
}

