/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.hifi;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseIcons;
import com.jtattoo.plaf.BaseRootPaneUI;
import com.jtattoo.plaf.BaseTitlePane;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.hifi.HiFiTitleButton;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JRootPane;

public class HiFiTitlePane
extends BaseTitlePane {
    private static Color fgColor = new Color(244, 244, 244);

    public HiFiTitlePane(JRootPane jRootPane, BaseRootPaneUI baseRootPaneUI) {
        super(jRootPane, baseRootPaneUI);
    }

    public void createButtons() {
        this.iconifyIcon = new BaseIcons.IconSymbol(fgColor, Color.black, Color.orange, new Insets(-1, -1, 0, 0));
        this.maximizeIcon = new BaseIcons.MaxSymbol(fgColor, Color.black, Color.orange, new Insets(-1, -1, 0, 0));
        this.minimizeIcon = new BaseIcons.MinSymbol(fgColor, Color.black, Color.orange, new Insets(-1, -1, 0, 0));
        this.closeIcon = new BaseIcons.CloseSymbol(fgColor, Color.black, Color.orange, new Insets(-1, -1, 0, 0));
        this.closeButton = new HiFiTitleButton(this.closeAction, "Close", this.closeIcon);
        this.iconifyButton = new HiFiTitleButton(this.iconifyAction, "Iconify", this.iconifyIcon);
        this.maxButton = new HiFiTitleButton(this.restoreAction, "Maximize", this.maximizeIcon);
    }

    public void paintBackground(Graphics graphics) {
        if (this.isActive()) {
            JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getWindowTitleColors(), 0, 0, this.getWidth(), this.getHeight());
        } else {
            JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), 0, 0, this.getWidth(), this.getHeight());
        }
    }

    public void paintText(Graphics graphics, int n, int n2, String string) {
        graphics.setColor(Color.black);
        JTattooUtilities.drawString(this.rootPane, graphics, string, n + 1, n2 + 1);
        if (this.isActive()) {
            graphics.setColor(AbstractLookAndFeel.getWindowTitleForegroundColor());
        } else {
            graphics.setColor(AbstractLookAndFeel.getWindowInactiveTitleForegroundColor());
        }
        JTattooUtilities.drawString(this.rootPane, graphics, string, n, n2);
    }
}

