/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.aluminium;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseIcons;
import com.jtattoo.plaf.BaseInternalFrameTitlePane;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.NoFocusButton;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JInternalFrame;

public class AluminiumInternalFrameTitlePane
extends BaseInternalFrameTitlePane {
    private static final Color foreColor = new Color(32, 32, 32);
    private static final Color shadowColor = new Color(232, 232, 232);
    private static final Color rolloverColor = new Color(196, 203, 163);

    public AluminiumInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    protected void createButtons() {
        this.iconIcon = new BaseIcons.IconSymbol(foreColor, shadowColor, rolloverColor, new Insets(0, 0, 1, 0));
        this.minIcon = new BaseIcons.MinSymbol(foreColor, shadowColor, rolloverColor, new Insets(0, 0, 1, 0));
        this.maxIcon = new BaseIcons.MaxSymbol(foreColor, shadowColor, rolloverColor, new Insets(0, 0, 1, 0));
        this.closeIcon = new BaseIcons.CloseSymbol(foreColor, Color.white, rolloverColor, new Insets(0, 0, 1, 0));
        this.iconButton = new NoFocusButton();
        this.iconButton.setContentAreaFilled(false);
        this.iconButton.setBorder(BorderFactory.createEmptyBorder());
        this.iconButton.addActionListener(this.iconifyAction);
        this.maxButton = new NoFocusButton();
        this.maxButton.setContentAreaFilled(false);
        this.maxButton.setBorder(BorderFactory.createEmptyBorder());
        this.maxButton.addActionListener(this.maximizeAction);
        this.closeButton = new NoFocusButton();
        this.closeButton.setContentAreaFilled(false);
        this.closeButton.setBorder(BorderFactory.createEmptyBorder());
        this.closeButton.addActionListener(this.closeAction);
        this.setButtonIcons();
    }

    public void paintPalette(Graphics graphics) {
        if (JTattooUtilities.isFrameActive(this)) {
            JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getWindowTitleColors(), 0, 0, this.getWidth(), this.getHeight() - 1);
        } else {
            JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), 0, 0, this.getWidth(), this.getHeight() - 1);
        }
    }

    public void paintBackground(Graphics graphics) {
        if (this.isActive()) {
            JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getWindowTitleColors(), 0, 0, this.getWidth(), this.getHeight() - 1);
        } else {
            JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), 0, 0, this.getWidth(), this.getHeight() - 1);
        }
    }

    public void paintBorder(Graphics graphics) {
        if (this.isActive()) {
            graphics.setColor(AbstractLookAndFeel.getTheme().getWindowBorderColor());
        } else {
            graphics.setColor(AbstractLookAndFeel.getTheme().getWindowInactiveBorderColor());
        }
        graphics.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }

    public void paintText(Graphics graphics, int n, int n2, String string) {
        if (this.isActive()) {
            graphics.setColor(AbstractLookAndFeel.getWindowTitleBackgroundColor());
            JTattooUtilities.drawString(this.frame, graphics, string, n + 1, n2 + 1);
            graphics.setColor(AbstractLookAndFeel.getWindowTitleForegroundColor());
            JTattooUtilities.drawString(this.frame, graphics, string, n, n2);
        } else {
            graphics.setColor(AbstractLookAndFeel.getWindowTitleBackgroundColor());
            JTattooUtilities.drawString(this.frame, graphics, string, n + 1, n2 + 1);
            graphics.setColor(AbstractLookAndFeel.getWindowInactiveTitleForegroundColor());
            JTattooUtilities.drawString(this.frame, graphics, string, n, n2);
        }
    }
}

