/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import javax.swing.text.View;

public class BaseRadioButtonUI
extends BasicRadioButtonUI {
    private static BaseRadioButtonUI radioButtonUI = null;

    public static ComponentUI createUI(JComponent jComponent) {
        if (radioButtonUI == null) {
            radioButtonUI = new BaseRadioButtonUI();
        }
        return radioButtonUI;
    }

    public void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        abstractButton.setRolloverEnabled(true);
        this.icon = UIManager.getIcon("RadioButton.icon");
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        Dimension dimension = jComponent.getSize();
        Font font = jComponent.getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle rectangle = new Rectangle(dimension);
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        Icon icon = abstractButton.getIcon();
        String string = SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, abstractButton.getText(), icon != null ? icon : this.getDefaultIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, this.getDefaultTextIconGap(abstractButton));
        if (jComponent.isOpaque()) {
            this.paintBackground(graphics, jComponent);
        }
        this.paintIcon(graphics, jComponent, rectangle2);
        if (string != null) {
            this.paintText(graphics, jComponent, string, rectangle3);
        }
        if (abstractButton.hasFocus() && abstractButton.isFocusPainted() && rectangle3.width > 0 && rectangle3.height > 0) {
            this.paintFocus(graphics, rectangle3, dimension);
        }
    }

    protected void paintBackground(Graphics graphics, JComponent jComponent) {
        graphics.setColor(jComponent.getBackground());
        graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
    }

    protected void paintIcon(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        Icon icon = abstractButton.getIcon();
        if (icon != null) {
            if (!buttonModel.isEnabled()) {
                icon = buttonModel.isSelected() ? abstractButton.getDisabledSelectedIcon() : abstractButton.getDisabledIcon();
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                icon = abstractButton.getPressedIcon();
                if (icon == null) {
                    icon = abstractButton.getSelectedIcon();
                }
            } else if (buttonModel.isSelected()) {
                if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
                    icon = abstractButton.getRolloverSelectedIcon();
                    if (icon == null) {
                        icon = abstractButton.getSelectedIcon();
                    }
                } else {
                    icon = abstractButton.getSelectedIcon();
                }
            } else if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
                icon = abstractButton.getRolloverIcon();
            }
            if (icon == null) {
                icon = abstractButton.getIcon();
            }
            icon.paintIcon(jComponent, graphics, rectangle.x, rectangle.y);
        } else {
            this.getDefaultIcon().paintIcon(jComponent, graphics, rectangle.x, rectangle.y);
        }
    }

    protected void paintText(Graphics graphics, JComponent jComponent, String string, Rectangle rectangle) {
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object = null;
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
            }
            view.paint(graphics, rectangle);
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
            }
        } else {
            AbstractButton abstractButton = (AbstractButton)jComponent;
            ButtonModel buttonModel = abstractButton.getModel();
            Font font = jComponent.getFont();
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = buttonModel.getMnemonic();
            if (JTattooUtilities.getJavaVersion() >= 1.4) {
                n = abstractButton.getDisplayedMnemonicIndex();
            }
            if (buttonModel.isEnabled()) {
                graphics.setColor(abstractButton.getForeground());
                JTattooUtilities.drawStringUnderlineCharAt(jComponent, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
            } else {
                graphics.setColor(Color.white);
                JTattooUtilities.drawStringUnderlineCharAt(jComponent, graphics, string, n, rectangle.x + 1, rectangle.y + 1 + fontMetrics.getAscent());
                graphics.setColor(AbstractLookAndFeel.getDisabledForegroundColor());
                JTattooUtilities.drawStringUnderlineCharAt(jComponent, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
            }
        }
    }

    protected void paintFocus(Graphics graphics, Rectangle rectangle, Dimension dimension) {
        graphics.setColor(AbstractLookAndFeel.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(graphics, rectangle.x, rectangle.y - 1, rectangle.width + 1, rectangle.height + 1);
    }
}

